/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.curd.utils;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.config.parser.curd.enums.JoinTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.QueryTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.utils.ConfigUtil;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQLParserUtil {
    private static final String DEFAULT_ALL_VALUE = "\u5168\u90e8";
    private static final String DEFAULT_NULL_VALUE = "NULL";

    public static JSONObject getSingleStyleQuerySQL(JSONObject queryParams) {
        String querySql = queryParams.getString("querySql");
        String countSql = queryParams.getString("countSql");
        JSONObject result = new JSONObject();
        result.put("items", (Object)querySql.substring(querySql.indexOf("SELECT") + 6, querySql.indexOf("FROM")));
        result.put("tableName", (Object)querySql.substring(querySql.indexOf("FROM") + 4, querySql.indexOf("WHERE")));
        result.put("condition", (Object)querySql.substring(querySql.indexOf("WHERE") + 5));
        result.put("countItems", (Object)countSql.substring(countSql.indexOf("SELECT") + 6, countSql.indexOf("FROM")));
        result.put("countTableName", (Object)countSql.substring(countSql.indexOf("FROM") + 4, countSql.indexOf("WHERE")));
        result.put("countCondition", (Object)countSql.substring(countSql.indexOf("WHERE") + 5));
        result.put("querySql", (Object)querySql);
        result.put("countSql", (Object)countSql);
        return result;
    }

    public static void putJoinCondition(String joinTableAlias, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray, Boolean useJoinByCount) {
        if (joinTableAlias.equals(tableAliasName) || joinTableAlias.equals("$")) {
            return;
        }
        if (joinTableNameObject.has(joinTableAlias)) {
            boolean isContains;
            boolean bl = isContains = SQLParserUtil.getCanJoinTableItem(canJoinTableNameArray, joinTableAlias) != null;
            if (!isContains) {
                JSONObject joinObj = joinTableNameObject.getJSONObject(joinTableAlias);
                String joinType = joinObj.getString("type");
                String joinCondition = joinObj.getString("value");
                JSONObject params = new JSONObject();
                params.put("type", (Object)joinType);
                params.put("alias", (Object)joinTableAlias);
                params.put("useJoinByCount", (Object)useJoinByCount);
                if (joinType.equals("join")) {
                    String shouldJoinTableAlias = SQLParserUtil.getShouldJoinTableAlias(joinTableAlias, tableAliasName, joinCondition = joinCondition.toLowerCase());
                    if (shouldJoinTableAlias != null) {
                        SQLParserUtil.putJoinCondition(shouldJoinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, useJoinByCount);
                    }
                    params.put("value", (Object)ConfigUtil.parseKey(JoinTypeEnum.LEFT_OUT_JOIN.getValue() + " " + joinCondition));
                } else {
                    params.put("value", (Object)joinCondition);
                }
                canJoinTableNameArray.put((Object)params);
            } else {
                JSONObject params = SQLParserUtil.getCanJoinTableItem(canJoinTableNameArray, joinTableAlias);
                assert (params != null);
                params.put("useJoinByCount", (Object)useJoinByCount);
                if (useJoinByCount.booleanValue()) {
                    String shouldJoinTableAlias;
                    JSONObject joinObj = joinTableNameObject.getJSONObject(joinTableAlias);
                    String joinType = joinObj.getString("type");
                    String joinCondition = joinObj.getString("value");
                    if (joinType.equals("join") && (shouldJoinTableAlias = SQLParserUtil.getShouldJoinTableAlias(joinTableAlias, tableAliasName, joinCondition = joinCondition.toLowerCase())) != null) {
                        params = SQLParserUtil.getCanJoinTableItem(canJoinTableNameArray, shouldJoinTableAlias);
                        assert (params != null);
                        params.put("useJoinByCount", true);
                        SQLParserUtil.putJoinCondition(shouldJoinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, true);
                    }
                }
            }
        } else {
            throw new ServiceException("\u5728\u7ec4\u7ec7JOIN\u8868\u8fbe\u5f0f\u65f6\uff0c\u6ca1\u6709\u627e\u5230\u5173\u4e8e\u8868\u522b\u540d[" + joinTableAlias + "]\u7684JOIN\u8868\u8fbe\u5f0f\u914d\u7f6e\u4fe1\u606f", Integer.valueOf(400));
        }
    }

    public static JSONObject getCanJoinTableItem(JSONArray canJoinTableNameArray, String alias) {
        for (Object itemObject : canJoinTableNameArray) {
            JSONObject item = (JSONObject)itemObject;
            if (!item.getString("alias").equals(alias)) continue;
            return item;
        }
        return null;
    }

    private static String getShouldJoinTableAlias(String joinTableAlias, String tableAliasName, String joinCondition) {
        String onCondition = joinCondition.substring(joinCondition.indexOf(" on ") + 4);
        String canJoinTableAliasA = onCondition.substring(0, onCondition.indexOf("."));
        String canJoinTableAliasB = onCondition.substring(onCondition.lastIndexOf("=") + 1, onCondition.lastIndexOf(".")).trim();
        if (!canJoinTableAliasA.equals(tableAliasName) && !canJoinTableAliasB.equals(tableAliasName)) {
            String shouldJoinTableAlias = canJoinTableAliasA.equals(joinTableAlias) ? canJoinTableAliasB : canJoinTableAliasA;
            return shouldJoinTableAlias;
        }
        return null;
    }

    public JSONObject getQuerySQL(JSONObject queryParamsMap, JSONObject params, String sortField, String sortOrder) {
        Object orderBy;
        String tableAliasName = queryParamsMap.getString("tableAliasName");
        StringBuilder querySql = new StringBuilder(queryParamsMap.getString("querySql"));
        StringBuilder countSql = new StringBuilder(queryParamsMap.getString("countSql"));
        JSONObject joinTableNameObject = queryParamsMap.getJSONObject("joinTableNameObject");
        JSONArray canJoinTableNameArray = queryParamsMap.getJSONArray("canJoinTableNameArray");
        if (sortField != null) {
            JSONObject queryParams;
            String realKey;
            String joinTableAlias;
            if (sortField.indexOf(46) == -1 || sortField.startsWith("$_")) {
                sortField = sortField.replaceFirst("_", ".");
            }
            if ((joinTableAlias = (realKey = (queryParams = queryParamsMap.getJSONObject("selectColumn").getJSONObject(sortField)).getString("key")).substring(0, realKey.indexOf(46))).equals("$")) {
                String[] spiltKeyArray = sortField.split(" ");
                realKey = spiltKeyArray[0].substring(2);
            }
            realKey = ConfigUtil.parseKey(realKey);
            orderBy = Optional.ofNullable(sortOrder).isPresent() && "descend".equals(sortOrder) ? realKey + " DESC" : realKey;
        } else {
            orderBy = queryParamsMap.getString("orderBy");
        }
        String conditionStr = queryParamsMap.getString("condition");
        String whereCondition = this.getValue(queryParamsMap.getJSONObject("selectColumn"), params, tableAliasName, joinTableNameObject, canJoinTableNameArray, conditionStr);
        Consumer<Object> consumer = item -> {
            Map joinObject = (Map)item;
            String condition = joinObject.get("value").toString();
            querySql.append("\n\t").append(condition);
            if (Boolean.parseBoolean(joinObject.get("useJoinByCount").toString())) {
                countSql.append("\n\t").append(condition);
            }
        };
        canJoinTableNameArray.toList().stream().filter(item -> ((Map)item).get("type").equals("json")).forEach(consumer);
        canJoinTableNameArray.toList().stream().filter(item -> ((Map)item).get("type").equals("join")).forEach(consumer);
        querySql.append("\nWHERE ").append(whereCondition);
        countSql.append("\nWHERE ").append(whereCondition);
        querySql.append("\nORDER BY ").append((String)orderBy);
        JSONObject result = new JSONObject();
        result.put("querySql", (Object)querySql.toString());
        result.put("countSql", (Object)countSql.toString());
        return result;
    }

    public JSONObject getSingleStyleQuerySQL(JSONObject queryParamsMap, JSONObject params, String sortField, String sortOrder) {
        JSONObject queryParams = this.getQuerySQL(queryParamsMap, params, sortField, sortOrder);
        return SQLParserUtil.getSingleStyleQuerySQL(queryParams);
    }

    public String getValue(JSONObject queryMap, JSONObject params, String tableAliasName, JSONObject joinTableNameObject, JSONArray canJoinTableNameArray, String conditionStr) {
        StringBuilder condition = new StringBuilder(conditionStr);
        Iterator iterator = params.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = String.valueOf(params.get(key));
            if (value.isEmpty() || DEFAULT_ALL_VALUE.equals(value)) continue;
            if (key.indexOf(46) == -1 || key.startsWith("$_")) {
                key = key.replaceFirst("_", ".");
            }
            if (queryMap.has(key)) {
                JSONObject queryParams = queryMap.getJSONObject(key);
                String queryTypeStr = queryParams.getString("queryType");
                if (!QueryTypeEnum.is(queryTypeStr)) {
                    throw new ServiceException("\u8868\u5355\u5b57\u6bb5[" + key + "]\u65e0\u6cd5\u751f\u6210\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u4e3a\u914d\u7f6e\u7684\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + queryTypeStr, Integer.valueOf(400));
                }
                QueryTypeEnum queryType = QueryTypeEnum.toType(queryTypeStr);
                String realKey = queryParams.getString("key");
                String joinTableAlias = realKey.substring(0, realKey.indexOf(46));
                if (joinTableAlias.equals("$")) {
                    String[] spiltKeyArray = key.split(" ");
                    realKey = spiltKeyArray[0].substring(2);
                }
                realKey = ConfigUtil.parseKey(realKey);
                switch (queryType) {
                    case EQUALS: 
                    case NO_EQUALS: 
                    case LESS_THAN: 
                    case LESS_THAN_EQUALS: 
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUALS: {
                        String mark = queryType.getValue();
                        if (DEFAULT_NULL_VALUE.equalsIgnoreCase(value)) {
                            condition.append("\n\tAND ").append(realKey).append(" IS NULL");
                            break;
                        }
                        condition.append("\n\tAND ").append(realKey).append(" ").append(mark).append(" '").append(value).append("'");
                        break;
                    }
                    case INNER_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("%'");
                        break;
                    }
                    case LEFT_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '%").append(value).append("'");
                        break;
                    }
                    case RIGHT_LIKE: {
                        condition.append("\n\tAND ").append(realKey).append(" LIKE '").append(value).append("%'");
                        break;
                    }
                    case IN: {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            value = CommonTools.union((JSONArray)JsonTools.parseArray((String)value));
                        }
                        condition.append("\n\tAND ").append(realKey).append(" IN (").append(value).append(")");
                        break;
                    }
                    case NOT_IN: {
                        if (value.startsWith("[") && value.endsWith("]")) {
                            value = CommonTools.union((JSONArray)JsonTools.parseArray((String)value));
                        }
                        condition.append("\n\tAND ").append(realKey).append(" NOT IN (").append(value).append(")");
                        break;
                    }
                    case BETWEEN: {
                        JSONArray array = new JSONArray(value);
                        condition.append("\n\tAND ").append(realKey).append(" BETWEEN '").append(array.get(0)).append("' AND '").append(array.get(1)).append("'");
                        break;
                    }
                    default: {
                        throw new ServiceException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b\uff1a" + queryType.getValue(), Integer.valueOf(400));
                    }
                }
                SQLParserUtil.putJoinCondition(joinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameArray, true);
                continue;
            }
            throw new ServiceException("\u8868\u5355\u5b57\u6bb5[" + key + "]\u65e0\u6cd5\u751f\u6210\u67e5\u8be2\u6761\u4ef6\uff0c\u56e0\u4e3a\u6ca1\u6709\u914d\u7f6e\u8fd9\u4e2a\u5b57\u6bb5\u7684\u76f8\u5173\u4fe1\u606f", Integer.valueOf(400));
        }
        return condition.toString();
    }
}

