package com.af.v4.system.common.liuli.config.parser.simpleform;

import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.AddOrEditTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.utils.FormBuildUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * 简单表单配置解析器
 * <p>
 * 详见 /docs/config/queryConfig/简单表单配置介绍.md
 *
 * @author Mr.river
 */
@Component
public class SimpleFormConfigParser extends ConfigParser {

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.SIMPLE_FORM;
    }

    /**
     * 根据配置文件生成简单表单
     */
    public JSONObject parse(JSONObject config) {
        // 配置文件的数据列集合
        JSONArray queryColumnArray = config.getJSONArray("column");
        // 组织生成的表单项集合
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        // 遍历数据列集合
        for (Object columnItem : queryColumnArray) {
            JSONObject column = (JSONObject) columnItem;
            // 获取该列的字段
            String key = column.getString("key");
            // 获取该列的表单类型
            FormTypeEnum formTypeEnum = FormBuildUtil.getFormType(column, key);
            // 组织表单项
            JSONObject item = new JSONObject();
            item.put("model", key.replace('.', '_'));
            item.put("type", formTypeEnum.getValue());
            item.put("name", column.getString("title"));
            FormBuildUtil.buildFileRes(column, formTypeEnum, item);
            if (column.has("selectKey")) {
                Object selectKey = column.get("selectKey");
                if (selectKey instanceof JSONArray) {
                    item.put("keys", selectKey);
                } else {
                    item.put("keyName", selectKey);
                }
            }
            FormBuildUtil.buildRuleAndPlaceholder(column, key, item);
            item.put("addOrEdit", AddOrEditTypeEnum.ALL.getValue());
            item.put("isOnlyAddOrEdit", true);
            formItemArray.put(item);
        }
        JSONObject columnResult = new JSONObject();
        columnResult.put("formJson", formItemArray);
        return columnResult;
    }
}
