package com.af.v4.system.common.liuli.config.parser.curd.utils;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.enums.CompatibleVersion;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.config.parser.curd.enums.CompatColumnNameEnum;
import org.springframework.stereotype.Component;

@Component
public class ConfigUtil {

    private static CompatibleVersion compatibleVersion;

    public ConfigUtil(ApplicationUtils applicationUtils) {
        compatibleVersion = applicationUtils.getVersion();
    }

    /**
     * 解析特殊数据参数
     *
     * @param key 特殊数据参数
     * @return 解析后的数据值
     */
    public static String parseKey(String key) {
        // 如果含$，代表为特殊数据参数
        int specialIndex = key.indexOf("$");
        while (specialIndex != -1) {
            boolean hasSpecialKey = false;
            CompatColumnNameEnum[] enums = CompatColumnNameEnum.values();
            for (CompatColumnNameEnum compatKey : enums) {
                if (key.contains(compatKey.getName())) {
                    hasSpecialKey = true;
                    key = key.replace(compatKey.getName(), compatKey.getValue(compatibleVersion));
                }
            }
            if (!hasSpecialKey) {
                throw new ServiceException("特殊列[" + key + "]无法处理，因为兼容性字段名不存在", HttpStatus.BAD_REQUEST);
            }
            specialIndex = key.indexOf("$");
        }
        return key;
    }
}
