package com.af.v4.system.common.liuli.config.parser.curd.enums;

import com.af.v4.system.common.liuli.config.parser.curd.entity.DataMode;

import java.util.stream.Stream;

/**
 * 数据模式类型
 * <p>
 * 各类型用法请参考docs/DataModeEnum.md
 *
 * @author Mr.river
 */
public enum DataModeEnum {
    /**
     * 全部
     */
    ALL("all", new DataMode(true, true, true, true, true, false)),
    /**
     * 数据表单
     */
    FORM("form", new DataMode(true, false, true, false, true, false)),
    /**
     * 数据表格列
     */
    TABLE("table", new DataMode(false, true, false, true, false, false)),
    /**
     * 表格表单
     */
    TABLE_FORM("table_form", new DataMode(false, true, false, true, true, false)),
    /**
     * 纯表单
     */
    ONLY_FORM("only_form", new DataMode(true, false, false, false, false, false)),
    /**
     * 纯表格
     */
    ONLY_TABLE("only_table", new DataMode(false, true, false, false, false, false)),
    /**
     * 纯查询
     */
    CLEAR("clear", new DataMode(false, false, false, true, true, false)),
    /**
     * 纯新增/修改表单
     */
    ONLY_ADD_MODIFY("only_add_modify", new DataMode(false, false, true, true, false, false)),
    /**
     * 组
     */
    GROUP("group", new DataMode(false, false, false, true, false, true));
    private final String value;
    private final DataMode dataMode;

    DataModeEnum(String value, DataMode dataMode) {
        this.value = value;
        this.dataMode = dataMode;
    }

    public static DataModeEnum toType(String value) {
        return Stream.of(DataModeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }

    public DataMode getDataMode() {
        return dataMode;
    }
}
