package com.af.v4.system.common.liuli.config;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.curd.CRUDFormConfigParser;
import com.af.v4.system.common.liuli.config.parser.json.JSONConfigParser;
import com.af.v4.system.common.liuli.config.parser.simpleform.SimpleFormConfigParser;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

/**
 * 配置解析器抽象类
 */
@Component
public abstract class ConfigParser {
    /**
     * 构建配置解析器
     *
     * @param liuLiConfigTypeEnum 配置类型
     * @return 配置解析器实例
     */
    public static ConfigParser build(LiuLiConfigTypeEnum liuLiConfigTypeEnum) {
        Class<? extends ConfigParser> clazz;
        switch (liuLiConfigTypeEnum) {
            case CRUD_FORM -> clazz = CRUDFormConfigParser.class;
            case SIMPLE_FORM -> clazz = SimpleFormConfigParser.class;
            default -> clazz = JSONConfigParser.class;
        }
        return SpringUtils.getBean(clazz);
    }

    /**
     * 获取配置类型名称
     *
     * @return 配置类型名称
     */
    public abstract LiuLiConfigTypeEnum getType();

    /**
     * 配置解析
     *
     * @return 解析后的配置
     */
    public abstract JSONObject parse(JSONObject source);
}
