package com.af.v4.system.common.liuli.config.parser.query.enums;

import java.util.stream.Stream;

/**
 * 新增/修改场景类型
 *
 * @author Mr.river
 */
public enum AddOrEditTypeEnum {
    //新增和修改
    ALL("all"),
    //仅支持新增
    ADD("add"),
    //仅支持修改
    EDIT("edit"),
    //静默新增
    SILENCE_ADD("silenceAdd"),
    //版本号
    VERSION("version"),
    //不支持
    NO("no");
    private final String value;

    AddOrEditTypeEnum(String value) {
        this.value = value;
    }

    public static AddOrEditTypeEnum toType(String value) {
        return Stream.of(AddOrEditTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
