package com.af.v4.system.common.liuli.config.enums;

import java.util.stream.Stream;

/**
 * 琉璃配置类型
 *
 * @author Mr.river
 */
public enum LiuLiConfigTypeEnum {
    // CRUD表单
    CRUD_FORM("CRUD_FORM"),
    // 简单表单
    SIMPLE_FORM("SIMPLE_FORM"),
    // JSON
    JSON("JSON"),
    // XML
    XML("XML");
    private final String value;

    LiuLiConfigTypeEnum(String value) {
        this.value = value;
    }

    public static LiuLiConfigTypeEnum toType(String value) {
        return Stream.of(LiuLiConfigTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(JSON);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
