/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.utils;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.redis.RedisService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LiuLiUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiUtil.class);
    private static final String CLOUD_URL_KEY = "LiuLiConfigCache@CloudUrl";
    private static final String DEFAULT_CLOUD_URL = "http://aote-office.8866.org:31039";
    private static final String CHECK_V4_VERSION_PATH = "/liuli/logic/checkV4Version";
    private final RedisService redisService;

    public LiuLiUtil(RedisService redisService) {
        this.redisService = redisService;
    }

    public JSONObject checkV4Version(String version) {
        String requestPath = this.getCloudUrl() + CHECK_V4_VERSION_PATH;
        R response = R.build((JSONObject)new JSONObject(RestTools.post((String)requestPath, (JSONObject)new JSONObject().put("version", (Object)version))));
        if (response.getCode() == 200) {
            return (JSONObject)response.getData();
        }
        LOGGER.warn("\u68c0\u67e5SystemV4\u7248\u672c\u5931\u8d25");
        return new JSONObject().put("hasUpdate", false);
    }

    public String getCloudUrl() {
        String cloudUrl;
        JSONObject url = (JSONObject)this.redisService.get(CLOUD_URL_KEY);
        if (url == null) {
            cloudUrl = DEFAULT_CLOUD_URL;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cloudUrl", (Object)cloudUrl);
            this.redisService.set(CLOUD_URL_KEY, (Object)jsonObject);
        } else {
            cloudUrl = url.getString("cloudUrl");
        }
        return cloudUrl;
    }

    public void updateCloudUrl(String cloudUrl) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cloudUrl", (Object)cloudUrl);
        this.redisService.lock(CLOUD_URL_KEY, () -> this.redisService.set(CLOUD_URL_KEY, (Object)jsonObject));
    }
}

