/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.monitor.service;

import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.http.RestAsyncTools;
import com.af.v4.system.common.plugins.http.core.response.EmptyAsyncResponse;
import com.af.v4.system.common.redis.RedisService;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class LiuLiMonitorService {
    private static final String UPLOAD_ERROR_LOG_PATH = "/liuli/logic/uploadErrorLog";
    private final ApplicationUtils applicationUtils;
    private final RedisService redisService;
    private final LiuLiUtil liuLiUtil;

    public LiuLiMonitorService(ApplicationUtils applicationUtils, RedisService redisService, LiuLiUtil liuLiUtil) {
        this.applicationUtils = applicationUtils;
        this.redisService = redisService;
        this.liuLiUtil = liuLiUtil;
    }

    public void uploadLogicErrorLog(JSONObject operLog) {
        String tenantUUID = (String)this.redisService.get("System@tenantUUID");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantUUID", (Object)tenantUUID);
        jsonObject.put("applicationName", (Object)this.applicationUtils.getApplicationName());
        jsonObject.put("environment", (Object)this.applicationUtils.getEnvType().getValue());
        jsonObject.put("method", operLog.opt("f_method"));
        jsonObject.put("requestMethod", operLog.opt("f_request_method"));
        jsonObject.put("operIp", operLog.opt("f_oper_ip"));
        jsonObject.put("operUrl", operLog.opt("f_oper_url"));
        jsonObject.put("operName", operLog.opt("f_oper_name"));
        jsonObject.put("operParam", operLog.opt("f_oper_param"));
        jsonObject.put("jsonResult", operLog.opt("f_json_result"));
        jsonObject.put("errorMsg", operLog.opt("f_error_msg"));
        jsonObject.put("businessTitle", operLog.opt("f_title"));
        jsonObject.put("businessType", operLog.opt("f_business_type"));
        jsonObject.put("operatorType", operLog.opt("f_operator_type"));
        jsonObject.put("costTime", operLog.opt("f_cost_time"));
        String requestPath = this.liuLiUtil.getCloudUrl() + UPLOAD_ERROR_LOG_PATH;
        RestAsyncTools.post((String)requestPath, (String)jsonObject.toString(), null, (FutureCallback)new EmptyAsyncResponse());
    }
}

