/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.service;

import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.ApplicationUtils;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.utils.LiuLiUtil;
import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.system.common.redis.RedisService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LiuLiConfigService {
    private static final String GET_CONFIG_PATH = "/liuli/logic/getConfigByClient";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiuLiConfigService.class);
    private final LiuLiUtil liuLiUtil;
    private final ApplicationUtils applicationUtils;
    private final RedisService redisService;
    private final DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory;

    public LiuLiConfigService(LiuLiUtil liuLiUtil, ApplicationUtils applicationUtils, RedisService redisService, DynamicFeignClientFactory<RemoteLogicService> dynamicFeignClientFactory) {
        this.liuLiUtil = liuLiUtil;
        this.applicationUtils = applicationUtils;
        this.redisService = redisService;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
    }

    public JSONObject get(String configName) {
        return this.get(configName, false);
    }

    public JSONObject get(String configName, Boolean isThrowExceptionOnConfigNotFound) {
        return this.getConfigByRedis(configName, key -> (JSONObject)this.redisService.lock(key, () -> this.getConfigByRedis(configName, key2 -> this.getConfigByDatabase(configName, () -> this.getConfigByRequest(configName, result -> {
            if (!isThrowExceptionOnConfigNotFound.booleanValue()) {
                LOGGER.warn("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u76f8\u5173\u4fe1\u606f\uff1a" + result);
                return null;
            }
            throw new ServiceException(result.getMsg(), Integer.valueOf(result.getCode()));
        })))));
    }

    private JSONObject getConfigByRedis(String configName, Function<String, JSONObject> notFoundFun) {
        String environment;
        String namespaceName = this.applicationUtils.getApplicationName();
        String configRedisKey = this.getConfigRedisKey(namespaceName, environment = this.applicationUtils.getEnvType().getValue(), configName);
        JSONObject configContent = (JSONObject)this.redisService.get(configRedisKey);
        if (configContent != null) {
            return configContent;
        }
        return notFoundFun.apply(configRedisKey);
    }

    private JSONObject getConfigByDatabase(String configName, Supplier<JSONObject> notFoundFun) {
        String namespaceName = this.applicationUtils.getApplicationName();
        String environment = this.applicationUtils.getEnvType().getValue();
        JSONObject params = new JSONObject();
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        try {
            Object data;
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            R result = remoteLogicService.run("getLiuLiConfig", params.toString(), "inner");
            if (result.getCode() == 200 && (data = result.getData()) != null) {
                JSONObject content = ((JSONObject)data).getJSONObject("content");
                this.addRedisCache(namespaceName, environment, configName, content);
                return content;
            }
        }
        catch (Throwable e) {
            LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:" + e.getMessage());
        }
        return notFoundFun.get();
    }

    private JSONObject getConfigByRequest(String configName, Function<R<JSONObject>, JSONObject> notFoundFun) {
        String tenantUUID = (String)this.redisService.get("System@tenantUUID");
        String namespaceName = this.applicationUtils.getApplicationName();
        String environment = this.applicationUtils.getEnvType().getValue();
        JSONObject params = new JSONObject();
        params.put("tenantUUID", (Object)tenantUUID);
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        String requestPath = this.liuLiUtil.getCloudUrl() + GET_CONFIG_PATH;
        String cloudConfig = RestTools.post((String)requestPath, (JSONObject)params);
        R result = R.build((JSONObject)new JSONObject(cloudConfig));
        if (result.getCode() == 200) {
            JSONObject data = (JSONObject)result.getData();
            LiuLiConfigTypeEnum type = LiuLiConfigTypeEnum.toType(data.getString("type"));
            JSONObject content = ConfigParser.build(type).parse(data.getJSONObject("content"));
            this.addRedisCache(namespaceName, environment, configName, content);
            this.addDatabaseCache(namespaceName, environment, configName, content);
            return content;
        }
        return notFoundFun.apply((R<JSONObject>)result);
    }

    public void addRedisCache(String namespaceName, String environment, String configName, JSONObject content) {
        String configRedisKey = this.getConfigRedisKey(namespaceName, environment, configName);
        this.redisService.set(configRedisKey, (Object)content);
    }

    public void addDatabaseCache(String namespaceName, String environment, String configName, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("namespaceName", (Object)namespaceName);
        params.put("environment", (Object)environment);
        params.put("configName", (Object)configName);
        params.put("configContent", (Object)content);
        try {
            RemoteLogicService remoteLogicService = (RemoteLogicService)this.dynamicFeignClientFactory.getFeignClient(RemoteLogicService.class, "af-system");
            remoteLogicService.run("addLiuLiConfig", params.toString(), "inner");
        }
        catch (Throwable e) {
            LOGGER.error("\u670d\u52a1\u8bf7\u6c42\u5931\u8d25:" + e.getMessage());
        }
    }

    public void removeCache(String namespaceName, String environment, String configName) {
        String configRedisKey = this.getConfigRedisKey(namespaceName, environment, configName);
        this.redisService.lock(configRedisKey, () -> this.redisService.delete(configRedisKey));
    }

    private String getConfigRedisKey(String namespaceName, String environment, String configName) {
        return "LiuLiConfigCache@" + namespaceName + "_" + environment + "_" + configName;
    }
}

