/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser.query.enums;

import java.util.stream.Stream;

public enum QueryTypeEnum {
    EQUALS("="),
    NO_EQUALS("!="),
    INNER_LIKE("LIKE"),
    LEFT_LIKE("LEFT_LIKE"),
    RIGHT_LIKE("RIGHT_LIKE"),
    GREATER_THAN(">"),
    GREATER_THAN_EQUALS(">="),
    LESS_THAN("<"),
    LESS_THAN_EQUALS("<="),
    IN("IN"),
    NOT_IN("NOT_IN"),
    BETWEEN("BETWEEN");

    private final String value;

    private QueryTypeEnum(String value) {
        this.value = value;
    }

    public static QueryTypeEnum toType(String value) {
        return Stream.of(QueryTypeEnum.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
    }

    public static boolean is(String value) {
        return QueryTypeEnum.toType(value) != null;
    }

    public String getValue() {
        return this.value;
    }
}

