/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.liuli.config.parser;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.liuli.config.ConfigParser;
import com.af.v4.system.common.liuli.config.enums.LiuLiConfigTypeEnum;
import com.af.v4.system.common.liuli.config.parser.query.DataMode;
import com.af.v4.system.common.liuli.config.parser.query.enums.AddOrEditTypeEnum;
import com.af.v4.system.common.liuli.config.parser.query.enums.ColumnFixedTypeEnum;
import com.af.v4.system.common.liuli.config.parser.query.enums.DataModeEnum;
import com.af.v4.system.common.liuli.config.parser.query.enums.FormTypeEnum;
import com.af.v4.system.common.liuli.config.parser.query.enums.QueryTypeEnum;
import com.af.v4.system.common.liuli.config.parser.query.enums.SilencePurposeEnum;
import com.af.v4.system.common.liuli.config.parser.query.enums.SlotTypeEnum;
import com.af.v4.system.common.liuli.config.parser.query.utils.ConfigUtil;
import com.af.v4.system.common.liuli.config.parser.query.utils.FormBuildUtil;
import com.af.v4.system.common.liuli.config.parser.query.utils.SQLParserUtil;
import com.alibaba.druid.DbType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CRUDFormConfigParser
extends ConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRUDFormConfigParser.class);

    @Override
    public LiuLiConfigTypeEnum getType() {
        return LiuLiConfigTypeEnum.CRUD_FORM;
    }

    @Override
    public JSONObject parse(JSONObject config) {
        String conditionStr;
        StringBuilder sql = new StringBuilder("SELECT ");
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0) n");
        String serviceName = config.optString("serviceName", "af-system");
        String tableName = ConfigUtil.parseKey(config.getString("tableName"));
        String tableAliasName = tableName.substring(tableName.indexOf(32) + 1);
        JSONObject joinTableNameObject = config.getJSONObject("joinArray");
        for (String key : joinTableNameObject.keySet()) {
            joinTableNameObject.put(key, (Object)ConfigUtil.parseKey(joinTableNameObject.getString(key)));
        }
        JSONObject buttonState = config.has("buttonState") ? config.getJSONObject("buttonState") : null;
        JSONObject apiSlot = config.has("apiSlot") ? config.getJSONObject("apiSlot") : null;
        JSONArray queryColumnArray = config.getJSONArray("column");
        JSONArray chineseQueryColumnArray = new JSONArray(queryColumnArray.length());
        JSONArray canJoinTableNameObject = new JSONArray();
        JSONObject selectColumnArray = new JSONObject();
        JSONArray showColumnArray = new JSONArray(queryColumnArray.length());
        JSONArray formItemArray = new JSONArray(queryColumnArray.length());
        for (Object columnItem : queryColumnArray) {
            AddOrEditTypeEnum addOrEditTypeEnum;
            DataMode dataModeObject;
            JSONArray dataModeArray;
            JSONObject column = (JSONObject)columnItem;
            String key = column.getString("key");
            int index = key.indexOf(46);
            index = index == -1 ? 0 : ++index;
            String realKey = key.substring(index);
            String columnAliasName = null;
            JSONArray jSONArray = dataModeArray = column.has("dataModeArray") ? column.getJSONArray("dataModeArray") : null;
            if (dataModeArray == null) {
                DataModeEnum dataModeEnum;
                if (!column.has("dataMode")) {
                    dataModeEnum = DataModeEnum.ALL;
                } else {
                    String dataMode = column.getString("dataMode");
                    dataModeEnum = DataModeEnum.toType(dataMode);
                    if (dataModeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u88ab\u5904\u7406\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u6570\u636e\u6a21\u5f0f\u4e0d\u5b58\u5728\uff1a" + dataMode, Integer.valueOf(400));
                    }
                }
                dataModeObject = dataModeEnum.getDataMode();
            } else {
                boolean queryForm = false;
                boolean table = false;
                boolean addOrEditForm = false;
                boolean sqlQueryItem = false;
                boolean sqlQueryCondition = false;
                for (Object item : dataModeArray) {
                    switch ((String)item) {
                        case "queryForm": {
                            queryForm = true;
                            break;
                        }
                        case "table": {
                            table = true;
                            break;
                        }
                        case "addOrEditForm": {
                            addOrEditForm = true;
                            break;
                        }
                        case "sqlQueryItem": {
                            sqlQueryItem = true;
                            break;
                        }
                        case "sqlQueryCondition": {
                            sqlQueryCondition = true;
                            break;
                        }
                    }
                }
                dataModeObject = new DataMode(queryForm, table, addOrEditForm, sqlQueryItem, sqlQueryCondition);
            }
            if (dataModeObject.sqlQueryItem()) {
                String columnName;
                String queryKey;
                String joinTableAlias = key.substring(0, key.indexOf(46));
                if (joinTableAlias.equals("$")) {
                    String[] spiltKeyArray = key.split(" ");
                    columnAliasName = "$_" + spiltKeyArray[1];
                    key = spiltKeyArray[0];
                    queryKey = spiltKeyArray[0].substring(2);
                } else {
                    columnAliasName = joinTableAlias + "_" + realKey;
                    queryKey = key;
                }
                queryKey = ConfigUtil.parseKey(queryKey);
                if (column.has("default")) {
                    Object defaultValue = String.valueOf(column.get("default"));
                    defaultValue = !((String)defaultValue).startsWith("$") ? "'" + (String)defaultValue + "'" : ((String)defaultValue).substring(1);
                    DbType dbType = DynamicDataSource.getDbType();
                    columnName = switch (dbType) {
                        case DbType.sqlserver -> "ISNULL(" + queryKey + "," + (String)defaultValue + ") AS\"" + columnAliasName + "\"";
                        case DbType.mysql -> "IFNULL(" + queryKey + "," + (String)defaultValue + ") AS\"" + columnAliasName + "\"";
                        case DbType.oracle -> "NVL(" + queryKey + "," + (String)defaultValue + ") AS\"" + columnAliasName + "\"";
                        default -> throw new ServiceException("\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\uff1a" + dbType);
                    };
                } else {
                    columnName = queryKey + " AS \"" + columnAliasName + "\"";
                }
                sql.append("\n\t").append(columnName).append(",");
                SQLParserUtil.putJoinCondition(joinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, false);
                chineseQueryColumnArray.put((Object)column.getString("title"));
            }
            if (dataModeObject.sqlQueryCondition()) {
                QueryTypeEnum queryTypeEnum;
                if (column.has("queryType")) {
                    String queryType = column.getString("queryType");
                    queryTypeEnum = QueryTypeEnum.toType(queryType);
                    if (queryTypeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u8868\u5355\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + queryType, Integer.valueOf(400));
                    }
                } else {
                    queryTypeEnum = QueryTypeEnum.EQUALS;
                }
                JSONObject selectColumnItem = new JSONObject();
                selectColumnItem.put("queryType", (Object)queryTypeEnum.getValue());
                selectColumnItem.put("key", (Object)key);
                selectColumnArray.put(key, (Object)selectColumnItem);
            }
            if (dataModeObject.table()) {
                JSONObject slot;
                JSONObject item = new JSONObject();
                item.put("title", (Object)column.getString("title"));
                item.put("dataIndex", columnAliasName == null ? realKey : columnAliasName);
                item.put("sorter", dataModeObject.sqlQueryItem());
                int width = 0;
                if (!column.has("slot")) {
                    slot = new JSONObject();
                    slot.put("type", (Object)"ellipsis");
                    slot.put("value", 16);
                } else {
                    slot = column.getJSONObject("slot");
                }
                JSONObject scopedSlots = new JSONObject();
                scopedSlots.put("customRender", columnAliasName == null ? realKey : columnAliasName);
                item.put("scopedSlots", (Object)scopedSlots);
                item.put("slots", (Object)scopedSlots);
                if (slot.has("type")) {
                    String slotType = slot.getString("type");
                    SlotTypeEnum slotTypeEnum = SlotTypeEnum.toType(slotType);
                    if (slotTypeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u63d2\u69fd\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u63d2\u69fd\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + slotType, Integer.valueOf(400));
                    }
                    item.put("slotType", (Object)slotType);
                    switch (slotTypeEnum) {
                        case DATE_TIME: {
                            width = 160;
                            break;
                        }
                        case ELLIPSIS: {
                            int ellipsisValue = slot.getInt("value");
                            BigDecimal b = new BigDecimal(String.valueOf(ellipsisValue * 7 + 20 + 32));
                            width = b.setScale(0, RoundingMode.UP).intValue();
                            item.put("slotValue", ellipsisValue);
                            break;
                        }
                        case BADGE: {
                            item.put("slotKeyMap", (Object)String.valueOf(slot.get("keyMap")));
                            width = 130;
                            break;
                        }
                        case ACTION: {
                            String actionText = slot.optString("actionText", "\u8be6\u60c5");
                            item.put("slotValue", (Object)actionText);
                        }
                    }
                } else {
                    throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u63d2\u69fd\uff0c\u56e0\u4e3a\u6ca1\u6709\u6307\u5b9a\u63d2\u69fd\u7c7b\u578b\u53c2\u6570", Integer.valueOf(400));
                }
                if (width > 0) {
                    item.put("width", width);
                }
                if (column.has("fixed")) {
                    String fixedType = column.getString("fixed");
                    ColumnFixedTypeEnum columnFixedTypeEnum = ColumnFixedTypeEnum.toType(fixedType);
                    if (columnFixedTypeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u9002\u7528\u56fa\u5b9a\u5217\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u56fa\u5b9a\u5217\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + fixedType, Integer.valueOf(400));
                    }
                    item.put("fixed", (Object)fixedType);
                }
                showColumnArray.put((Object)item);
            }
            if (!dataModeObject.queryForm() && !dataModeObject.addOrEditForm()) continue;
            FormTypeEnum formTypeEnum = FormBuildUtil.getFormType(column, key);
            if (dataModeObject.addOrEditForm()) {
                if (column.has("addOrEdit")) {
                    String addOrEditType = column.getString("addOrEdit");
                    addOrEditTypeEnum = AddOrEditTypeEnum.toType(addOrEditType);
                    if (addOrEditTypeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u65b0\u589e/\u4fee\u6539\u573a\u666f\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + addOrEditType, Integer.valueOf(400));
                    }
                } else {
                    addOrEditTypeEnum = AddOrEditTypeEnum.ALL;
                }
            } else {
                addOrEditTypeEnum = AddOrEditTypeEnum.NO;
            }
            JSONObject item = new JSONObject();
            FormBuildUtil.buildFileRes(column, formTypeEnum, item);
            item.put("model", (Object)key.replaceFirst("\\.", "_"));
            item.put("type", (Object)formTypeEnum.getValue());
            item.put("queryType", (Object)column.optString("queryType", null));
            item.put("name", (Object)column.getString("title"));
            if (column.has("selectKeyName")) {
                String selectKeyName = column.getString("selectKeyName");
                String joinTableAlias = selectKeyName.substring(0, selectKeyName.indexOf(46));
                index = key.indexOf(46);
                index = index == -1 ? 0 : ++index;
                String realSelectKey = selectKeyName.substring(index);
                if (!selectKeyName.equals(key)) {
                    sql.append("\n\t").append(selectKeyName).append(" ").append(joinTableAlias).append("_").append(realSelectKey).append(",");
                    JSONObject selectColumnItem = new JSONObject();
                    selectColumnItem.put("queryType", (Object)column.optString("queryType", QueryTypeEnum.EQUALS.getValue()));
                    selectColumnItem.put("key", (Object)selectKeyName);
                    selectColumnArray.put(selectKeyName, (Object)selectColumnItem);
                    item.put("model", (Object)selectKeyName.replace('.', '_'));
                }
            }
            if (column.has("selectKey")) {
                Object selectKey = column.get("selectKey");
                if (selectKey instanceof JSONArray) {
                    item.put("keys", selectKey);
                } else {
                    item.put("keyName", selectKey);
                }
                if (column.has("lazyLoad")) {
                    item.put("lazyLoad", column.get("lazyLoad"));
                }
            }
            FormBuildUtil.buildRuleAndPlaceholder(column, key, item);
            item.put("addOrEdit", (Object)addOrEditTypeEnum.getValue());
            item.put("isOnlyAddOrEdit", !dataModeObject.queryForm());
            if (addOrEditTypeEnum == AddOrEditTypeEnum.SILENCE_ADD) {
                if (column.has("silencePurpose")) {
                    String silencePurpose = column.getString("silencePurpose");
                    SilencePurposeEnum silencePurposeEnum = SilencePurposeEnum.toType(silencePurpose);
                    if (silencePurposeEnum == null) {
                        throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u8fd9\u4e2a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u6307\u5b9a\u7684\u5b57\u6bb5\u7528\u9014\u4e0d\u5b58\u5728\uff1a" + silencePurpose, Integer.valueOf(400));
                    }
                    if (silencePurposeEnum == SilencePurposeEnum.CUSTOMIZE) {
                        if (column.has("silenceSource")) {
                            item.put("silenceSource", (Object)column.getString("silenceSource"));
                        } else {
                            throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u7684\u81ea\u5b9a\u4e49\u5b57\u6bb5\u7528\u9014\u5fc5\u987b\u6307\u5b9a\u4e1a\u52a1\u903b\u8f91\u540d\u79f0(silenceSource)", Integer.valueOf(400));
                        }
                    }
                    item.put("silencePurpose", (Object)column.getString("silencePurpose"));
                } else {
                    throw new ServiceException("\u5217[" + key + "]\u65e0\u6cd5\u751f\u6210\u8868\u5355\u9879\uff0c\u56e0\u4e3a\u9759\u9ed8\u65b0\u589e\u573a\u666f\u5fc5\u987b\u6307\u5b9a\u5b57\u6bb5\u7528\u9014", Integer.valueOf(400));
                }
            }
            formItemArray.put((Object)item);
        }
        String orderBy = config.getString("orderBy");
        String joinTableAlias = orderBy.substring(0, orderBy.indexOf(46));
        SQLParserUtil.putJoinCondition(joinTableAlias, tableAliasName, joinTableNameObject, canJoinTableNameObject, false);
        if (config.has("condition")) {
            JSONObject condition = config.getJSONObject("condition");
            conditionStr = condition.getString("value");
            if (condition.has("join")) {
                JSONArray joinArray = condition.getJSONArray("join");
                for (Object item : joinArray) {
                    String joinItem = item.toString();
                    SQLParserUtil.putJoinCondition(joinItem, tableAliasName, joinTableNameObject, canJoinTableNameObject, true);
                }
            }
        } else {
            conditionStr = "1=1";
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append("\n").append("FROM ").append(tableName);
        countSql.append("\n").append("FROM ").append(tableName);
        JSONObject result = new JSONObject();
        result.put("tableName", (Object)tableName);
        result.put("tableAliasName", (Object)tableAliasName);
        result.put("countSql", (Object)countSql.toString());
        result.put("querySql", (Object)sql.toString());
        result.put("joinTableNameObject", (Object)joinTableNameObject);
        result.put("canJoinTableNameObject", (Object)canJoinTableNameObject);
        result.put("selectColumn", (Object)selectColumnArray);
        result.put("orderBy", (Object)orderBy);
        result.put("condition", (Object)conditionStr);
        result.put("columnJson", (Object)showColumnArray);
        result.put("formJson", (Object)formItemArray);
        result.put("buttonState", (Object)buttonState);
        result.put("apiSlot", (Object)apiSlot);
        result.put("serviceName", (Object)serviceName);
        result.put("chineseQueryColumnArray", (Object)chineseQueryColumnArray);
        return result;
    }
}

