package com.af.v4.system.common.jpa.enums;

/**
 * 数据库列类型
 */
public enum ColumnTypeEnum {
    COL_STRING("STRING"),
    COL_DATE("DATE"),
    COL_TIME("TIME"),
    COL_BOOLEAN("BOOLEAN"),
    COL_INTEGER("INTEGER"),
    COL_LONG("LONG"),
    COL_DOUBLE("DOUBLE"),
    COL_DECIMAL("DECIMAL"),
    COL_CLOB("CLOB"),
    COL_NOT_SUPPORTED("NOT_SUPPORTED");

    private final String value;

    ColumnTypeEnum(String value) {
        this.value = value;
    }

    public static ColumnTypeEnum toType(String value) {
        return normalizeType(value);
    }

    /**
     * 获取列类型
     */
    private static ColumnTypeEnum normalizeType(String type) {
        type = type.toLowerCase();
        return switch (type) {
            case "string" -> ColumnTypeEnum.COL_STRING;
            case "date" -> ColumnTypeEnum.COL_DATE;
            case "time", "timestamp" -> ColumnTypeEnum.COL_TIME;
            case "boolean", "yes_no" -> ColumnTypeEnum.COL_BOOLEAN;
            case "integer" -> ColumnTypeEnum.COL_INTEGER;
            case "big_integer", "long" -> ColumnTypeEnum.COL_LONG;
            case "double" -> ColumnTypeEnum.COL_DOUBLE;
            case "big_decimal" -> ColumnTypeEnum.COL_DECIMAL;
            case "clob" -> ColumnTypeEnum.COL_CLOB;
            default -> ColumnTypeEnum.COL_NOT_SUPPORTED;
        };
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }


    @Override
    public String toString() {
        return getValue();
    }
}
