/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.utils;

import cn.hutool.core.util.StrUtil;
import java.util.stream.Stream;
import org.json.JSONArray;

public class Condition {
    private final StringBuilder conditionValue = new StringBuilder();

    private Condition() {
    }

    public static Condition build() {
        return new Condition();
    }

    private Condition appendCondition(QueryType queryType, String column, Object value) {
        if (queryType != QueryType.IS_NULL && queryType != QueryType.IS_NOT_NULL) {
            this.conditionValue.append(column).append(" ").append(queryType.value).append(" '").append(value).append("'");
        } else {
            this.conditionValue.append(column).append(" ").append(queryType.value);
        }
        return this;
    }

    public Condition and() {
        this.conditionValue.append(" AND ");
        return this;
    }

    public Condition or() {
        this.conditionValue.append(" OR ");
        return this;
    }

    public Condition eq(String column, Object value) {
        QueryType queryType = StrUtil.equalsIgnoreCase((CharSequence)(value == null ? "NULL" : value.toString()), (CharSequence)"NULL") ? QueryType.IS_NULL : QueryType.EQUALS;
        return this.appendCondition(queryType, column, value);
    }

    public Condition neq(String column, Object value) {
        QueryType queryType = StrUtil.equalsIgnoreCase((CharSequence)(value == null ? "NULL" : value.toString()), (CharSequence)"NULL") ? QueryType.IS_NOT_NULL : QueryType.NOT_EQUALS;
        return this.appendCondition(queryType, column, value);
    }

    public Condition gt(String column, Object value) {
        return this.appendCondition(QueryType.GREATER_THEN, column, value);
    }

    public Condition gtEquals(String column, Object value) {
        return this.appendCondition(QueryType.GREATER_EQUALS_THEN, column, value);
    }

    public Condition lt(String column, Object value) {
        return this.appendCondition(QueryType.LESS_THEN, column, value);
    }

    public Condition ltEquals(String column, Object value) {
        return this.appendCondition(QueryType.LESS_EQUALS_THEN, column, value);
    }

    public Condition between(String column, Object beginValue, Object endValue) {
        this.conditionValue.append(column).append(" BETWEEN '").append(beginValue).append("' AND '").append(endValue).append("'");
        return this;
    }

    public Condition like(String column, Object value) {
        this.conditionValue.append(column).append(" LIKE '%").append(value).append("%'");
        return this;
    }

    public Condition rightLike(String column, Object value) {
        this.conditionValue.append(column).append(" LIKE '").append(value).append("%'");
        return this;
    }

    public Condition leftLike(String column, Object value) {
        this.conditionValue.append(column).append(" LIKE '%").append(value).append("'");
        return this;
    }

    public Condition notIn(String column, String ... values) {
        return this.notIn(column, new JSONArray((Object)values));
    }

    public Condition notIn(String column, JSONArray values) {
        this.conditionValue.append(column).append(" NOT IN (");
        for (Object value : values) {
            this.conditionValue.append("'").append(value).append("',");
        }
        this.conditionValue.deleteCharAt(this.conditionValue.length() - 1).append(")");
        return this;
    }

    public Condition in(String column, String ... values) {
        return this.in(column, new JSONArray((Object)values));
    }

    public Condition in(String column, JSONArray values) {
        this.conditionValue.append(column).append(" IN (");
        for (Object value : values) {
            this.conditionValue.append("'").append(value).append("',");
        }
        this.conditionValue.deleteCharAt(this.conditionValue.length() - 1).append(")");
        return this;
    }

    public Condition orderBy(String column) {
        this.conditionValue.append(" ORDER BY ").append(column);
        return this;
    }

    public String getValue() {
        return this.conditionValue.toString();
    }

    public static enum QueryType {
        EQUALS("="),
        NOT_EQUALS("!="),
        IS_NULL("IS NULL"),
        IS_NOT_NULL("IS NOT NULL"),
        GREATER_THEN(">"),
        GREATER_EQUALS_THEN(">="),
        LESS_THEN("<"),
        LESS_EQUALS_THEN("<=");

        private final String value;

        private QueryType(String value) {
            this.value = value;
        }

        public static QueryType toType(String value) {
            return Stream.of(QueryType.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
        }

        public static boolean is(String value) {
            return QueryType.toType(value) != null;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum WhereType {
        AND("AND"),
        OR("OR");

        private final String value;

        private WhereType(String value) {
            this.value = value;
        }

        public static WhereType toType(String value) {
            return Stream.of(WhereType.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
        }

        public static boolean is(String value) {
            return WhereType.toType(value) != null;
        }

        public String getValue() {
            return this.value;
        }
    }
}

