/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.config;

import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactoryImpl;
import com.af.v4.system.common.jpa.dynamic.DynamicTransactionManager;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.annotation.Nonnull;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;

@Configuration
@ConfigurationProperties(prefix="spring.datasource")
public class HibernateConfig
implements ApplicationContextInitializer<AbstractApplicationContext> {
    @Bean(name={"entityManagerFactory"})
    public DynamicSessionFactory dynamicSessionFactory() {
        return new DynamicSessionFactoryImpl();
    }

    @Bean
    public DynamicTransactionManager transactionManager() {
        DynamicTransactionManager transactionManager = new DynamicTransactionManager();
        transactionManager.setSessionFactory(this.dynamicSessionFactory());
        return transactionManager;
    }

    public void initialize(@Nonnull AbstractApplicationContext context) {
        DataSourceProperties dataSourceProperties = (DataSourceProperties)context.getBean(DataSourceProperties.class);
        dataSourceProperties.setType(HikariDataSource.class);
    }
}

