package com.af.v4.system.common.jpa.service;

import com.af.v4.system.common.jpa.session.SessionPool;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.sql.PreparedStatement;
import java.util.concurrent.atomic.AtomicInteger;

@Service
@Transactional(propagation = Propagation.NOT_SUPPORTED)
public class ClickhouseService {

    private final SessionPool sessionPool;

    public ClickhouseService(SessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    /**
     * 保存数据到clickhouse
     *
     * @param targetTable 目标表
     * @param data        数据
     * @return 影响行数
     */
    public int save(String targetTable, JSONObject data) {
        return save(targetTable, new JSONArray().put(data));
    }

    /**
     * 保存一批数据到clickhouse
     *
     * @param targetTable 目标表
     * @param dataList    数据集合
     * @return 影响行数
     */
    public int save(String targetTable, JSONArray dataList) {
        String sql = "INSERT INTO " + targetTable + " FORMAT JSONEachRow";
        AtomicInteger affectedRows = new AtomicInteger();
        sessionPool.getSession().doWork(connection -> {
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setString(1, dataList.toString());
            affectedRows.set(statement.executeUpdate());
        });
        return affectedRows.get();
    }
}
