/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.report.service;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.expression.report.core.Report;
import com.af.v4.system.common.expression.report.core.Sql;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.mapper.PluginMapper;
import com.af.v4.system.common.resource.mapper.ReportMapper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ReportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportService.class);
    private final ApplicationUtils applicationUtils;
    private final ReportMapper reportMapper;
    private final SqlService sqlService;

    public ReportService(ApplicationUtils applicationUtils, ReportMapper reportMapper, SqlService sqlService) {
        this.applicationUtils = applicationUtils;
        this.reportMapper = reportMapper;
        this.sqlService = sqlService;
    }

    public Object run(String reportName, JSONObject params) {
        ReportMapper.ReportResource resource = (ReportMapper.ReportResource)this.reportMapper.getResource(reportName);
        String name = resource.getAlias();
        String path = resource.getPath();
        LOGGER.info("\u6267\u884cReport[{}]\uff0cpath\uff1a{}", (Object)name, (Object)path);
        String source = resource.getSource();
        params.put("ENV", (Object)this.applicationUtils.getValues());
        params.put("RESOURCE", (Object)resource.getJsonParams());
        PluginMapper.getPluginMap().forEach((arg_0, arg_1) -> ((JSONObject)params).put(arg_0, arg_1));
        Report report = new Report(source, params);
        return this.runExpression(report);
    }

    public Object runExpression(Report report) {
        for (Sql item : report.sqls) {
            Program proc = new Program(item.param);
            Delegate delegate = proc.parse();
            JSONObject json = (JSONObject)delegate.invoke(report.vars);
            JSONArray ret = this.sqlService.query(item.sql, json);
            report.vars.put(item.name, ret);
        }
        return report.render();
    }
}

