/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.StrUtil;
import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.config.DynamicDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.jpa.action.SqlAction;
import com.af.v4.system.common.jpa.enums.ColumnTypeEnum;
import com.af.v4.system.common.jpa.enums.IDTypeEnum;
import com.af.v4.system.common.jpa.service.ClickhouseService;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.jpa.types.SubClasses;
import com.af.v4.system.common.jpa.utils.Condition;
import com.af.v4.system.common.jpa.utils.Pair;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.io.IOTools;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.uuid.UuidGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EntityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityService.class);
    private static final Map<String, Map<String, Map<String, Object>>> META_MAP = new ConcurrentHashMap<String, Map<String, Map<String, Object>>>();
    private static final Map<String, Map<String, String>> ENTITY_LIFT_MAP = new ConcurrentHashMap<String, Map<String, String>>();
    private static Map<String, Map<String, String>> SUBCLASS_MODULE_MAP;
    private final SessionPool sessionPool;
    private final SqlAction sqlAction;
    private final DynamicDataSourceConfig dynamicDataSourceConfig;
    private final DynamicFeignClientFactory<RemoteEntityService> dynamicFeignClientFactory;
    private final ClickhouseService clickhouseService;

    public EntityService(SessionPool sessionPool, SqlAction sqlAction, DynamicDataSourceConfig dynamicDataSourceConfig, DynamicFeignClientFactory<RemoteEntityService> dynamicFeignClientFactory, ClickhouseService clickhouseService) {
        this.sessionPool = sessionPool;
        this.sqlAction = sqlAction;
        this.dynamicDataSourceConfig = dynamicDataSourceConfig;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.clickhouseService = clickhouseService;
    }

    public static Map<String, Map<String, String>> getSubClassMap() {
        return SUBCLASS_MODULE_MAP;
    }

    public static Map<String, String> getEntityLiftMap() {
        String dataSourceName = DynamicDataSource.getDataSource();
        return ENTITY_LIFT_MAP.computeIfAbsent(dataSourceName, k -> new HashMap());
    }

    public static Map<String, Map<String, Object>> getMetaMap() {
        String dataSourceName = DynamicDataSource.getDataSource();
        return META_MAP.computeIfAbsent(dataSourceName, k -> new HashMap());
    }

    public static String getEntityLiftValueByKey(String entityName) {
        return EntityService.getEntityLiftMap().get(entityName);
    }

    public static Map<String, Object> getMetaMapItemByKey(String entityName) {
        Map<String, Object> result = EntityService.getMetaMap().get(entityName);
        if (result == null) {
            String dataSourceName = DynamicDataSource.getDataSource();
            throw new ServiceException("\u6570\u636e\u6e90[" + dataSourceName + "]\u7684\u5b9e\u4f53[" + entityName + "]\u4e0d\u5b58\u5728", Integer.valueOf(400));
        }
        return result;
    }

    private static void putEntityLiftValue(String key, String value) {
        EntityService.getEntityLiftMap().put(key, value);
    }

    public static void putMetaMapItem(String key, Map<String, Object> value) {
        EntityService.getMetaMap().put(key, value);
    }

    public static Condition getCondition() {
        return Condition.build();
    }

    @PostConstruct
    public void init() {
        this.loadSubclassMap();
        this.loadMetaData();
    }

    public JSONObject getById(String columns, String entityName, Object id, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String sql = "SELECT " + columns + " FROM " + String.valueOf(map.get("tableName")) + " WHERE " + String.valueOf(map.get("idName")) + " = '" + String.valueOf(id) + "'";
        JSONArray result = this.sqlAction.queryAll("EntityService@getById", sql, dataSourceName);
        if (result.isEmpty()) {
            return null;
        }
        return result.getJSONObject(0);
    }

    public JSONObject getById(String columns, String entityName, Object id) {
        return this.getById(columns, entityName, id, null);
    }

    public JSONObject getById(String entityName, Object id) {
        return this.getById("*", entityName, String.valueOf(id));
    }

    public JSONArray getByCondition(String columns, String entityName, Condition condition, String order, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String sql = "SELECT " + columns + " FROM " + String.valueOf(map.get("tableName")) + " WHERE " + condition.getValue();
        if (order != null) {
            sql = sql + " ORDER BY " + order;
        }
        return this.sqlAction.queryAll("EntityService@getByCondition", sql, dataSourceName);
    }

    public JSONArray getByCondition(String columns, String entityName, Condition condition, String order) {
        return this.getByCondition(columns, entityName, condition, order, null);
    }

    public JSONArray getByCondition(String columns, String entityName, Condition condition) {
        return this.getByCondition(columns, entityName, condition, null);
    }

    public JSONArray getByCondition(String entityName, Condition condition) {
        return this.getByCondition("*", entityName, condition, null);
    }

    public JSONArray getByCondition(String entityName, Condition condition, String order) {
        return this.getByCondition("*", entityName, condition, order);
    }

    public Integer delete(String entityName, Object id, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String sql = "DELETE FROM " + String.valueOf(map.get("tableName")) + " WHERE " + String.valueOf(map.get("idName")) + " = '" + String.valueOf(id) + "'";
        return this.sqlAction.exec("EntityService@Delete", sql, dataSourceName);
    }

    public Integer delete(String entityName, Object id) {
        return this.delete(entityName, id, null);
    }

    public Integer deleteAllByIds(String entityName, JSONArray ids, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String idStr = CommonTools.union((JSONArray)ids);
        String sql = "DELETE FROM " + String.valueOf(map.get("tableName")) + " WHERE " + String.valueOf(map.get("idName")) + " IN (" + idStr + " )";
        return this.sqlAction.exec("EntityService@deleteAllByIds", sql, dataSourceName);
    }

    public Integer deleteAllByIds(String entityName, JSONArray ids) {
        return this.deleteAllByIds(entityName, ids, null);
    }

    public JSONArray findAllByIds(String columns, String entityName, JSONArray ids, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String idStr = CommonTools.union((JSONArray)ids);
        String sql = "SELECT " + columns + " FROM " + String.valueOf(map.get("tableName")) + " WHERE " + String.valueOf(map.get("idName")) + " IN (" + idStr + " )";
        return this.sqlAction.queryAll("EntityService@findAllByIds", sql, dataSourceName);
    }

    public JSONArray findAllByIds(String columns, String entityName, JSONArray ids) {
        return this.findAllByIds(columns, entityName, ids, null);
    }

    public JSONArray findAllByIds(String entityName, JSONArray ids) {
        return this.findAllByIds("*", entityName, ids);
    }

    public Long getCount(String entityName, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String sql = "SELECT COUNT(0) count FROM " + String.valueOf(map.get("tableName"));
        JSONArray result = this.sqlAction.queryAll("EntityService@getCount", sql, dataSourceName);
        return !result.isEmpty() ? result.getJSONObject(0).getLong("count") : 0L;
    }

    public Long getCount(String entityName) {
        return this.getCount(entityName, null);
    }

    public JSONArray findAll(String columns, String entityName, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String sql = "SELECT " + columns + " FROM " + String.valueOf(map.get("tableName"));
        return this.sqlAction.queryAll("EntityService@findAll", sql, dataSourceName);
    }

    public JSONArray findAll(String columns, String entityName) {
        return this.findAll(columns, entityName, null);
    }

    public JSONArray findAll(String entityName) {
        return this.findAll("*", entityName);
    }

    public JSONObject saveByKey(String entityName, JSONObject row, JSONArray keyArray, Boolean isCover, String dataSourceName) throws IOException, ClassNotFoundException {
        Condition condition = Condition.build();
        int keyArrayLength = keyArray.length();
        for (int i = 0; i < keyArrayLength; ++i) {
            String keyName = keyArray.getString(i);
            condition = condition.eq(keyName, row.get(keyName));
            if (i >= keyArrayLength - 1) continue;
            condition.and();
        }
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String idName = map.get("idName").toString();
        JSONArray entityDataList = this.getByCondition(idName, entityName, condition);
        int entityDataLength = entityDataList.length();
        if (entityDataLength == 1) {
            if (!isCover.booleanValue()) {
                throw new ServiceException("\u5b9e\u4f53[" + entityName + "]\u5bf9\u5e94\u7684\u6570\u636e\u5df2\u5b58\u5728", Integer.valueOf(400));
            }
            row.put(idName, entityDataList.getJSONObject(0).get(idName));
        } else {
            if (entityDataLength > 1) {
                throw new ServiceException("\u5b9e\u4f53[" + entityName + "]\u5bf9\u5e94\u7684\u6570\u636e\u6761\u6570\u6709\u8bef\uff0c\u9884\u671f\uff1a1\uff0c\u5b9e\u9645\uff1a" + entityDataLength, Integer.valueOf(400));
            }
            row.remove(idName);
        }
        return this.partialSave(entityName, row);
    }

    public JSONObject saveByKey(String entityName, JSONObject row, JSONArray keyArray, Boolean isCover) throws IOException, ClassNotFoundException {
        return this.saveByKey(entityName, row, keyArray, isCover, null);
    }

    public JSONObject saveByKey(String entityName, JSONObject row, JSONArray keyArray) throws IOException, ClassNotFoundException {
        return this.saveByKey(entityName, row, keyArray, true);
    }

    public JSONArray overrideSave(String entityName, JSONArray rowArray, String foreignName, Object foreignId, String dataSourceName) throws IOException, ClassNotFoundException {
        this.sqlAction.exec("EntityService@doDelete", "DELETE FROM " + entityName + " WHERE" + foreignName + " = " + String.valueOf(foreignId), dataSourceName);
        return this.partialSave(entityName, rowArray, dataSourceName);
    }

    public JSONArray overrideSave(String entityName, JSONArray rowArray, String foreignName, Object foreignId) throws IOException, ClassNotFoundException {
        return this.overrideSave(entityName, rowArray, foreignName, foreignId, null);
    }

    public String getTablePrimaryKey(String entityName) {
        return EntityService.getMetaMapItemByKey(entityName).get("idName").toString();
    }

    public JSONObject partialSave(String entityName, JSONObject row, String dataSourceName) throws IOException, ClassNotFoundException {
        return this.partialSave(entityName, new JSONArray().put((Object)row), dataSourceName).getJSONObject(0);
    }

    public JSONObject partialSave(String entityName, JSONObject row) throws IOException, ClassNotFoundException {
        return this.partialSave(entityName, row, null);
    }

    public JSONArray partialSave(String entityName, JSONArray rowArray, String dataSourceName) throws IOException, ClassNotFoundException {
        JSONArray result;
        DbType dbType = DynamicDataSource.getDbType();
        if (dbType == DbType.clickhouse) {
            result = new JSONArray();
            this.clickhouseService.save(entityName, rowArray);
        } else {
            Map md;
            if (EntityService.getEntityLiftMap().containsKey(entityName)) {
                String pEntityName = EntityService.getEntityLiftValueByKey(entityName);
                md = this.deepClone((HashMap)EntityService.getMetaMapItemByKey(pEntityName));
                this.enchanceMetaData(md, entityName);
            } else {
                md = EntityService.getMetaMapItemByKey(entityName);
            }
            List<Serializable> aid = this.partialSave(rowArray, (Map<String, Object>)md, null, null, dataSourceName);
            result = new JSONArray(aid.size());
            aid.forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put((String)md.get("idName"), (Object)item.toString());
                result.put((Object)obj);
            });
        }
        return result;
    }

    public JSONArray partialSave(String entityName, JSONArray rowArray) throws IOException, ClassNotFoundException {
        return this.partialSave(entityName, rowArray, null);
    }

    private void partialSave(JSONObject row, Map<String, Object> md, Object pIdValue, String pEntityName, String dataSourceName) {
        JSONArray array = new JSONArray(1);
        array.put((Object)row);
        this.partialSave(array, md, pIdValue, pEntityName, dataSourceName);
    }

    private List<Serializable> partialSave(JSONArray rowArray, Map<String, Object> md, Object pIdValue, String pEntityName, String dataSourceName) {
        ArrayList<Serializable> result = new ArrayList<Serializable>(rowArray.length());
        rowArray.forEach(item -> {
            int affectedRows;
            JSONObject row = (JSONObject)item;
            Object idValue = null;
            String idName = (String)md.get("idName");
            ColumnTypeEnum idType = (ColumnTypeEnum)((Object)((Object)md.get("idType")));
            if (row.has(idName)) {
                idValue = row.get(idName);
            }
            Map columns = (Map)md.get("columns");
            Map links = (Map)md.get("links");
            boolean isInsert = false;
            if (idValue == null || idValue == JSONObject.NULL) {
                affectedRows = this.doInsert(row, md, pIdValue, pEntityName, idName, idType, columns, dataSourceName);
            } else if (IDTypeEnum.toType((String)md.get("idGenerator")) != IDTypeEnum.ID_ASSIGNED) {
                affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, idValue, idType, columns, dataSourceName);
            } else if (this.hasRow((String)md.get("tableName"), (String)md.get("idColName"), idValue, idType, dataSourceName)) {
                affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, idValue, idType, columns, dataSourceName);
            } else {
                isInsert = true;
                affectedRows = this.doInsert(row, md, pIdValue, pEntityName, idName, idType, columns, dataSourceName);
            }
            if (affectedRows == 0) {
                throw new ServiceException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u5f71\u54cd\u884c\u6570\u4e3a:0", Integer.valueOf(400));
            }
            idValue = row.get(idName);
            if (isInsert) {
                row.remove(idName);
            }
            Iterator itr = row.keys();
            while (itr.hasNext()) {
                String attr = (String)itr.next();
                if (!links.containsKey(attr) || !row.has(attr)) continue;
                Pair pair = (Pair)links.get(attr);
                Map<String, Object> cmd = EntityService.getMetaMapItemByKey(pair.col);
                String cEntityName = (String)md.get("entityName");
                if (row.isNull(attr)) {
                    if (!pair.col.equals(attr)) continue;
                    this.delete((String)cmd.get("tableName"), row.get(idName));
                    continue;
                }
                this.doSave(row, idValue, attr, cmd, cEntityName, dataSourceName);
            }
            result.add((Serializable)idValue);
        });
        return result;
    }

    private void doSave(JSONObject row, Object idValue, String attr, Map<String, Object> cmd, String pEntityName, String dataSourceName) {
        Object obj = row.get(attr);
        if (obj instanceof JSONArray) {
            JSONArray rows = row.getJSONArray(attr);
            for (int i = 0; i < rows.length(); ++i) {
                this.partialSave(rows.getJSONObject(i), cmd, idValue, pEntityName, dataSourceName);
            }
        } else {
            this.partialSave((JSONObject)obj, cmd, idValue, pEntityName, dataSourceName);
        }
    }

    private boolean hasRow(String tableName, String idColName, Object idValue, ColumnTypeEnum idType, String dataSourceName) {
        return !this.sqlAction.queryAll("EntityService@hasRow", "select 1 from " + tableName + " where " + idColName + "=" + this.normalizeValue(idValue, idType), dataSourceName).isEmpty();
    }

    private int doUpdate(JSONObject row, Map<String, Object> md, Object pIdValue, String pEntityName, Object idValue, ColumnTypeEnum idType, Map<String, Pair> columns, String dataSourceName) {
        HashMap associations;
        if (row.keySet().size() == 1) {
            return -1;
        }
        Object verValue = null;
        String verName = (String)md.get("verName");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        StringBuilder sb = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null && associations.containsKey(pEntityName)) {
            Pair pair = (Pair)associations.get(pEntityName);
            foreignkey = pair.col;
            sb.append(" ").append(foreignkey).append("=").append(this.normalizeValue(pIdValue, pair.type)).append(", ");
        }
        if (verName != null) {
            ColumnTypeEnum verType = (ColumnTypeEnum)((Object)md.get("verType"));
            sb.append(" ").append(verName).append("=").append(this.normalizeVer(verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sb.append(" ").append(pair.col).append("=").append((String)(row.isNull(attr) ? "null, " : this.normalizeValue(row.get(attr), pair.type) + ", "));
        }
        if (sb.isEmpty()) {
            LOGGER.error("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a{}", (Object)row);
            throw new RuntimeException("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + String.valueOf(row));
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.insert(0, "UPDATE " + String.valueOf(md.get("tableName")) + " SET");
        sb.append(" WHERE ").append(md.get("idColName")).append(" = ").append(this.normalizeValue(idValue, idType));
        if (md.get("verName") != null) {
            ColumnTypeEnum verType = (ColumnTypeEnum)((Object)md.get("verType"));
            sb.append(" AND ").append(md.get("verColName")).append(" = ").append(this.normalizeValue(verValue, verType));
        }
        int affectedRow = this.sqlAction.exec("EntityService@doUpdate", sb.toString(), dataSourceName);
        if (md.containsKey("subclasses")) {
            LinkedHashMap subclasses = (LinkedHashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                SubClasses p = (SubClasses)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String pTypeStr = p.type;
                String dv = row.getString(p.col);
                if (!pTypeStr.equals(dv) && !pTypeStr.contains(dv + ",") && !pTypeStr.contains("," + dv)) continue;
                StringBuilder buf = new StringBuilder();
                Map<String, Object> smd = EntityService.getMetaMapItemByKey(sentity);
                String keyAttr = (String)smd.get("idName");
                Map attrs = (Map)smd.get("columns");
                for (String attr : attrs.keySet()) {
                    if (attr.equals(keyAttr) || !row.has(attr)) continue;
                    Pair a = (Pair)attrs.get(attr);
                    buf.append(a.col).append("=").append(this.normalizeValue(row.isNull(attr) ? null : row.get(attr), a.type)).append(", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.insert(0, "UPDATE " + String.valueOf(smd.get("tableName")) + " SET ");
                buf.append(" WHERE ").append(smd.get("idColName")).append(" = ").append(this.normalizeValue(idValue, idType));
                this.sqlAction.exec("EntityService@doUpdate-child", buf.toString(), dataSourceName);
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair = (Pair)links.get(attr);
                    Map<String, Object> cmd = EntityService.getMetaMapItemByKey(pair.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr)) {
                        if (!pair.col.equals(attr)) continue;
                        this.delete((String)cmd.get("tableName"), idValue);
                        continue;
                    }
                    this.doSave(row, idValue, attr, cmd, cEntityName, dataSourceName);
                }
                break block1;
            }
        }
        this.handleInverses(row, md, dataSourceName);
        return affectedRow;
    }

    private void handleInverses(JSONObject row, Map<String, Object> md, String dataSourceName) {
        HashMap inverses = (HashMap)md.get("inverses");
        for (String inverse : inverses.keySet()) {
            Object arow;
            if (row.isNull(inverse) || !((arow = row.get(inverse)) instanceof JSONObject)) continue;
            Map<String, Object> amd = EntityService.getMetaMapItemByKey((String)inverses.get(inverse));
            this.partialSave((JSONObject)arow, amd, null, null, dataSourceName);
        }
    }

    private int doInsert(JSONObject row, Map<String, Object> md, Object pIdValue, String pEntityName, String idName, ColumnTypeEnum idType, Map<String, Pair> columns, String dataSourceName) {
        int affectedRows;
        HashMap associations;
        Object verValue = null;
        String verName = (String)md.get("verName");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        String idColName = (String)md.get("idColName");
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null) {
            for (String ass : associations.keySet()) {
                if (!ass.equals(pEntityName) && !this.hasParent(ass, pEntityName)) continue;
                Pair pair = (Pair)associations.get(ass);
                foreignkey = pair.col;
                if (sbCols.indexOf(foreignkey + ",") != -1) continue;
                sbCols.append(foreignkey).append(", ");
                sbValues.append(this.normalizeValue(pIdValue, pair.type)).append(", ");
            }
        }
        if (verName != null) {
            sbCols.append(verName).append(", ");
            ColumnTypeEnum verType = (ColumnTypeEnum)((Object)md.get("verType"));
            sbValues.append(this.normalizeVer(verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sbCols.append(pair.col).append(", ");
            sbValues.append((String)(row.isNull(attr) ? "null, " : this.normalizeValue(row.get(attr), pair.type) + ", "));
        }
        String idStrategy = (String)md.get("idGenerator");
        IDTypeEnum idTypeEnum = IDTypeEnum.toType(idStrategy);
        switch (idTypeEnum) {
            case ID_GUID: {
                sbCols.append(idColName).append(", ");
                String guid = UUID.randomUUID().toString().replace("-", "");
                sbValues.append("'").append(guid).append("', ");
                row.put(idName, (Object)guid);
                break;
            }
            case ID_SEQ: {
                sbCols.append(idColName).append(", ");
                String aid = this.getLastSeqId((String)md.get("sequence"), dataSourceName);
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
            case ID_ASSIGNED: {
                sbCols.append(idColName).append(", ");
                sbValues.append(this.normalizeValue(row.get(idName), idType)).append(", ");
                row.put(idName, row.get(idName));
                break;
            }
            case ID_FOREIGNER: {
                sbCols.append(idColName).append(", ");
                String aid = this.normalizeValue(pIdValue, idType);
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
        }
        if (md.containsKey("inverses")) {
            HashMap inverses = (HashMap)md.get("inverses");
            HashMap inversesid = (HashMap)md.get("inverseid");
            for (String inverse : inverses.keySet()) {
                Pair pair;
                if (row.isNull(inverse)) continue;
                Object arow = row.get(inverse);
                if (!(arow instanceof JSONObject)) {
                    pair = (Pair)inversesid.get(inverse);
                    sbCols.append(pair.col).append(", ");
                    sbValues.append(this.normalizeValue(arow, pair.type)).append(", ");
                    continue;
                }
                JSONObject json = (JSONObject)arow;
                sbCols.append(inverse).append(", ");
                pair = (Pair)inversesid.get(inverse);
                arow = json.get(pair.col);
                sbValues.append(this.normalizeValue(arow, pair.type)).append(", ");
            }
        }
        sbCols.delete(sbCols.length() - 2, sbCols.length());
        sbCols.insert(0, "INSERT INTO " + String.valueOf(md.get("tableName")) + " (");
        sbValues.delete(sbValues.length() - 2, sbValues.length());
        sbCols.append(") VALUES (");
        sbCols.append((CharSequence)sbValues);
        sbCols.append(")");
        if (idTypeEnum == IDTypeEnum.ID_AUTO) {
            Tuple tuple;
            try {
                tuple = this.rawJdbcUpdate(sbCols.toString(), dataSourceName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            row.put(idName, (Object)tuple.get(1).toString());
            affectedRows = (Integer)tuple.get(0);
        } else {
            affectedRows = this.sqlAction.exec("EntityService@doInsert", sbCols.toString(), dataSourceName);
        }
        if (md.containsKey("subclasses")) {
            LinkedHashMap subclasses = (LinkedHashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Map associations2;
                SubClasses p = (SubClasses)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String pTypeStr = p.type;
                String dv = row.getString(p.col);
                if (!pTypeStr.equals(dv) && !pTypeStr.contains(dv + ",") && !pTypeStr.contains("," + dv)) continue;
                StringBuilder fields = new StringBuilder();
                StringBuilder vals = new StringBuilder();
                Map<String, Object> smd = EntityService.getMetaMapItemByKey(sentity);
                String keyCol = (String)smd.get("idColName");
                fields.append(keyCol).append(", ");
                vals.append(this.normalizeValue(row.get(idName), idType)).append(", ");
                Map attrs = (Map)smd.get("columns");
                for (Object attr : attrs.keySet()) {
                    if (!row.has((String)attr)) continue;
                    Pair a = (Pair)attrs.get(attr);
                    if (a.col.equals(foreignkey)) continue;
                    fields.append(a.col).append(", ");
                    vals.append(this.normalizeValue(row.isNull(attr) ? null : row.get(attr), a.type)).append(", ");
                }
                if (smd.containsKey("inverseid")) {
                    Map lookup = (Map)smd.get("inverseid");
                    for (String property : lookup.keySet()) {
                        if (!row.has(property) || row.isNull(property)) continue;
                        Object obj = row.get(property);
                        Pair pair = (Pair)lookup.get(property);
                        if (obj instanceof JSONObject) {
                            JSONObject record = (JSONObject)obj;
                            if (!record.has(pair.col) || record.isNull(pair.col)) continue;
                            fields.append(pair.col).append(", ");
                            vals.append(this.normalizeValue(record.get(pair.col), pair.type)).append(", ");
                            continue;
                        }
                        fields.append(pair.col).append(", ");
                        vals.append(this.normalizeValue(row.get(property), pair.type)).append(", ");
                    }
                }
                if ((associations2 = (Map)md.get("associations")) != null) {
                    for (String ass : associations2.keySet()) {
                        Pair pair = (Pair)associations2.get(ass);
                        foreignkey = pair.col;
                        if (!attrs.containsKey(foreignkey) || pIdValue == null || fields.indexOf(foreignkey + ", ") != -1) continue;
                        fields.append(foreignkey).append(", ");
                        vals.append(this.normalizeValue(pIdValue, pair.type)).append(", ");
                    }
                }
                fields.delete(fields.length() - 2, fields.length());
                vals.delete(vals.length() - 2, vals.length());
                fields.insert(0, "INSERT INTO " + String.valueOf(smd.get("tableName")) + " (");
                fields.append(") VALUES (");
                fields.append((CharSequence)vals);
                fields.append(")");
                this.sqlAction.exec("EntityService@doInsert-child", fields.toString(), dataSourceName);
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair = (Pair)links.get(attr);
                    Map<String, Object> cmd = EntityService.getMetaMapItemByKey(pair.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr)) {
                        if (!pair.col.equals(attr)) continue;
                        this.delete((String)cmd.get("tableName"), row.get(idName));
                        continue;
                    }
                    this.doSave(row, row.get(idName), attr, cmd, cEntityName, dataSourceName);
                }
                break block11;
            }
        }
        this.handleInverses(row, md, dataSourceName);
        return affectedRows;
    }

    private boolean hasParent(String entity, String pEntityName) {
        if (EntityService.getEntityLiftMap().containsKey(entity)) {
            return true;
        }
        while (EntityService.getEntityLiftMap().containsKey(entity)) {
            String pEntity = EntityService.getEntityLiftValueByKey(entity);
            if (pEntity.equals(pEntityName)) {
                return true;
            }
            entity = pEntity;
        }
        return false;
    }

    private Tuple rawJdbcUpdate(String sql, String dataSourceName) {
        AtomicReference tuple = new AtomicReference();
        return (Tuple)DynamicDataSource.withDataSource((String)dataSourceName, () -> {
            this.sessionPool.getSession().doWork(connection -> {
                LOGGER.info("\u6267\u884c\u539f\u751fSQL\uff1a{\n{}\n}", (Object)sql);
                PreparedStatement statement = connection.prepareStatement(sql, 1);
                int affectedRows = statement.executeUpdate();
                if (affectedRows != 0) {
                    ResultSet rs = statement.getGeneratedKeys();
                    if (rs.next()) {
                        String idValue = String.valueOf(rs.getLong(1));
                        tuple.set(new Tuple(new Object[]{affectedRows, idValue}));
                    } else {
                        throw new RuntimeException("\u5f97\u5230\u63d2\u5165\u8bb0\u5f55id\u5931\u8d25\u3002");
                    }
                }
            });
            return (Tuple)tuple.get();
        });
    }

    private String getLastSeqId(String seq, String dataSourceName) {
        DbType dbType = DynamicDataSource.getDbType();
        String sql = dbType == DbType.postgresql ? "SELECT nextval('" + seq + "') newid" : "select " + seq + ".nextval newid from dual";
        return this.sqlAction.queryAll("EntityService@getLastSeqId", sql, dataSourceName).getJSONObject(0).get("newid").toString();
    }

    private String normalizeVer(Object verValue, ColumnTypeEnum verType) {
        DbType dbType = DynamicDataSource.getDbType();
        if (verType == ColumnTypeEnum.COL_TIME) {
            if (dbType == DbType.oracle) {
                return "current_timestamp";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + sdf.format(new Date()) + "'";
        }
        if (verValue == null) {
            return "1";
        }
        return String.valueOf(Integer.parseInt(String.valueOf(verValue)) + 1);
    }

    private String normalizeValue(Object value, ColumnTypeEnum valType) {
        if (value == null) {
            return "null";
        }
        DbType dbType = DynamicDataSource.getDbType();
        switch (valType) {
            case COL_STRING: {
                return "'" + String.valueOf(value) + "'";
            }
            case COL_INTEGER: 
            case COL_DOUBLE: 
            case COL_LONG: 
            case COL_DECIMAL: {
                if ("".equals(value)) {
                    return "null";
                }
                return String.valueOf(value);
            }
            case COL_BOOLEAN: {
                if (dbType == DbType.oracle) {
                    return "'" + ((Boolean)value != false ? "Y" : "N") + "'";
                }
                if (value instanceof Byte) {
                    return value.toString();
                }
                if (value instanceof Integer) {
                    return value.toString();
                }
                return (Boolean)value != false ? "1" : "0";
            }
            case COL_DATE: {
                if (dbType == DbType.oracle) {
                    return "TO_DATE(SUBSTR('" + String.valueOf(value) + "', 1, 10), 'YYYY-MM-DD')";
                }
                return "'" + String.valueOf(value) + "'";
            }
            case COL_TIME: {
                if (dbType == DbType.oracle) {
                    return "TO_TIMESTAMP('" + String.valueOf(value) + "', 'YYYY-MM-DD HH24:MI:SS')";
                }
                return "'" + String.valueOf(value) + "'";
            }
            case COL_CLOB: {
                if (dbType == DbType.oracle) {
                    String[] parts;
                    StringBuilder sql = new StringBuilder();
                    for (String part : parts = StrUtil.split((CharSequence)value.toString(), (int)2000)) {
                        sql.append("TO_CLOB('").append(part).append("')||");
                    }
                    int length = sql.length();
                    sql.delete(length - 2, length);
                    return sql.toString();
                }
                return "'" + String.valueOf(value) + "'";
            }
        }
        throw new ServiceException("\u4f20\u9012\u6570\u636e\u7c7b\u578b\u51fa\u9519", Integer.valueOf(506));
    }

    public void sqlserverBulkInsert(String entityName, JSONArray rowArray, String dataSourceName) {
        Map<String, Object> map = EntityService.getMetaMapItemByKey(entityName);
        String tableName = map.get("tableName").toString();
        String idColName = map.get("idColName").toString();
        ColumnTypeEnum typeEnum = (ColumnTypeEnum)((Object)map.get("idType"));
        Map normalColumns = (Map)map.get("columns");
        HashMap<String, Pair> allColumns = new HashMap<String, Pair>(normalColumns.size() + 1);
        allColumns.put(idColName, new Pair(idColName, typeEnum));
        allColumns.putAll((Map)map.get("columns"));
        DynamicDataSource.withDataSource((String)dataSourceName, () -> this.sessionPool.getSession().doWork(connection -> {
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + tableName + " WHERE 1 = 0");
            try (ResultSet rs = statement.executeQuery();
                 CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();){
                crs.populate(rs);
                for (Object o : rowArray) {
                    JSONObject params = (JSONObject)o;
                    crs.moveToInsertRow();
                    for (Map.Entry entry : allColumns.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = params.opt(key);
                        Pair pair = (Pair)entry.getValue();
                        ColumnTypeEnum columnTypeEnum = pair.type;
                        switch (columnTypeEnum) {
                            case COL_STRING: {
                                crs.updateString(key, value == null ? "" : value.toString());
                                break;
                            }
                            case COL_INTEGER: {
                                crs.updateInt(key, Integer.parseInt(value == null ? "0" : value.toString()));
                                break;
                            }
                            case COL_LONG: {
                                crs.updateLong(key, Long.parseLong(value == null ? "0" : value.toString()));
                                break;
                            }
                            case COL_DOUBLE: {
                                crs.updateDouble(key, Double.parseDouble(value == null ? "0" : value.toString()));
                                break;
                            }
                            case COL_TIME: {
                                crs.updateTimestamp(key, new Timestamp((value == null ? DateTime.now() : DateUtil.parse((CharSequence)value.toString())).toSqlDate().getTime()));
                                break;
                            }
                            case COL_DATE: {
                                crs.updateDate(key, (value == null ? DateTime.now() : DateUtil.parse((CharSequence)value.toString())).toSqlDate());
                                break;
                            }
                            case COL_BOOLEAN: {
                                crs.updateBoolean(key, Boolean.parseBoolean(value == null ? "false" : value.toString()));
                                break;
                            }
                            case COL_DECIMAL: {
                                crs.updateBigDecimal(key, new BigDecimal(value == null ? "0" : value.toString()));
                            }
                        }
                    }
                    crs.insertRow();
                    crs.moveToCurrentRow();
                }
                SQLServerBulkCopyOptions copyOptions = new SQLServerBulkCopyOptions();
                copyOptions.setKeepIdentity(true);
                copyOptions.setBatchSize(8000);
                copyOptions.setUseInternalTransaction(true);
                AfDataSourceConfig dataSource = DynamicDataSource.getWrapper().getConfig();
                Object jdbcUrl = dataSource.getUrl();
                if (!((String)jdbcUrl).endsWith(";")) {
                    jdbcUrl = (String)jdbcUrl + ";";
                }
                jdbcUrl = (String)jdbcUrl + "username=" + dataSource.getUsername() + ";password=" + dataSource.getPassword() + ";";
                try (SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((String)jdbcUrl);){
                    bulkCopy.setBulkCopyOptions(copyOptions);
                    bulkCopy.setDestinationTableName(tableName);
                    bulkCopy.writeToServer((RowSet)crs);
                }
            }
        }));
    }

    public void loadSubclassMap() {
        SUBCLASS_MODULE_MAP = new LinkedHashMap<String, Map<String, String>>();
        List subClassList = this.dynamicDataSourceConfig.getSubClass();
        if (subClassList != null) {
            for (String name : subClassList) {
                HashMap<String, String> module = new HashMap<String, String>(1);
                module.put("name", name);
                SUBCLASS_MODULE_MAP.put(name, module);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadMetaData() {
        Set dataSourceNameList = DynamicDataSource.getDataSourceMap().keySet();
        for (String dataSource : dataSourceNameList) {
            DynamicDataSource.withDataSource((String)dataSource, () -> {
                Map<String, AbstractEntityPersister> map = this.getStringClassMetadataMap();
                for (String entityName : map.keySet()) {
                    this.getMetaData(entityName);
                }
                for (String entityName : map.keySet()) {
                    Map<String, Object> hash = EntityService.getMetaMapItemByKey(entityName);
                    MappingMetamodelImplementor metamodel = this.sessionPool.getSessionFactory().getMappingMetamodel();
                    EntityPersister cmd = metamodel.getEntityDescriptor(entityName);
                    HashMap<String, String> inverses = new HashMap<String, String>(16);
                    hash.put("inverses", inverses);
                    HashMap<String, Pair> inverseMap = new HashMap<String, Pair>(16);
                    hash.put("inverseid", inverseMap);
                    for (String property : cmd.getPropertyNames()) {
                        EntityMappingType type = cmd.findAttributeMapping(property).findContainingEntityMapping();
                        if (!(type instanceof ManyToOneType)) continue;
                        ManyToOneType mto = (ManyToOneType)type;
                        String linkedEntity = mto.getAssociatedEntityName();
                        String colName = mto.getAssociatedJoinable((SessionFactoryImplementor)this.sessionPool.getSessionFactory()).getKeyColumnNames()[0];
                        inverses.put(property, linkedEntity);
                        inverseMap.put(property, new Pair(colName, (ColumnTypeEnum)((Object)((Object)((Object)EntityService.getMetaMapItemByKey(linkedEntity).get("idType"))))));
                    }
                }
            });
        }
        SAXReader reader = new SAXReader();
        IOTools.getStream((String)"subclass.xml", stream -> this.loadSubclass(reader, stream));
        Map<String, Map<String, String>> maps = EntityService.getSubClassMap();
        for (String string : maps.keySet()) {
            void var5_5;
            if (!"".equals(string)) {
                String string2 = string + "/";
            }
            void finalModuleName = var5_5;
            IOTools.getStream((String)("/" + (String)finalModuleName + "subclass.xml"), stream -> this.loadSubclass(reader, stream), arg_0 -> EntityService.lambda$loadMetaData$11((String)finalModuleName, arg_0));
        }
    }

    private Map<String, AbstractEntityPersister> getStringClassMetadataMap() {
        MetamodelImplementor metaModelImpl = this.sessionPool.getSessionFactory().getMetamodel();
        LinkedHashMap<String, AbstractEntityPersister> map = new LinkedHashMap<String, AbstractEntityPersister>(48);
        metaModelImpl.forEachEntityDescriptor(entityPersister -> {
            AbstractEntityPersister aep = (AbstractEntityPersister)entityPersister;
            map.put(aep.getEntityName(), aep);
        });
        return map;
    }

    private void loadSubclass(SAXReader reader, InputStream input) {
        Document document;
        try {
            document = reader.read(input);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("entity");
        while (it.hasNext()) {
            LinkedHashMap subclasses;
            Element elm = (Element)it.next();
            String entityName = elm.attribute("name").getValue();
            String parentEntity = elm.attribute("parentEntity").getValue();
            String discProperty = elm.attribute("discProperty").getValue();
            String discriminator = elm.attribute("discriminator").getValue();
            if (!EntityService.getMetaMap().containsKey(parentEntity)) continue;
            Map<String, Object> em = EntityService.getMetaMapItemByKey(parentEntity);
            if (em.containsKey("subclasses")) {
                subclasses = (LinkedHashMap)em.get("subclasses");
            } else {
                subclasses = new LinkedHashMap();
                em.put("subclasses", subclasses);
            }
            subclasses.put(entityName, new SubClasses(discProperty, discriminator));
            EntityService.putEntityLiftValue(entityName, parentEntity);
        }
    }

    private Map<String, Object> getMetaData(String entityName) {
        if (EntityService.getMetaMap().containsKey(entityName)) {
            return EntityService.getMetaMapItemByKey(entityName);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("entityName", entityName);
        MappingMetamodelImplementor metamodel = this.sessionPool.getSessionFactory().getMappingMetamodel();
        AbstractEntityPersister aep = (AbstractEntityPersister)metamodel.getEntityDescriptor(entityName);
        map.put("tableName", aep.getTableName());
        String attr = aep.getIdentifierPropertyName();
        if (attr == null) {
            LOGGER.warn("\u505c\u6b62\u5904\u7406\u3010{}\u3011\u7684\u6620\u5c04\uff0c\u53ef\u80fd\u542b\u6709\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7ed3\u6784", (Object)entityName);
            return null;
        }
        map.put("idName", attr);
        String idColName = aep.getPropertyColumnNames(attr)[0];
        map.put("idColName", idColName);
        ColumnTypeEnum idType = ColumnTypeEnum.toType(aep.getIdentifierType().getName());
        map.put("idType", (Object)idType);
        Generator idg = aep.getGenerator();
        if (idg instanceof UUIDGenerator || idg instanceof UuidGenerator || idg instanceof UUIDHexGenerator || idg instanceof GUIDGenerator) {
            map.put("idGenerator", IDTypeEnum.ID_GUID.getValue());
        } else if (idg instanceof SequenceStyleGenerator) {
            SequenceStyleGenerator generator = (SequenceStyleGenerator)idg;
            String name = generator.getDatabaseStructure().getPhysicalName().render();
            map.put("sequence", name);
            map.put("idGenerator", IDTypeEnum.ID_SEQ.getValue());
        } else if (idg instanceof IdentityGenerator) {
            map.put("idGenerator", IDTypeEnum.ID_AUTO.getValue());
        } else if (idg instanceof Assigned) {
            map.put("idGenerator", IDTypeEnum.ID_ASSIGNED.getValue());
        } else if (idg instanceof ForeignGenerator) {
            map.put("idGenerator", IDTypeEnum.ID_FOREIGNER.getValue());
        } else {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684Hibernate Id\u751f\u6210\u5668\u7c7b\u578b\uff0c\u8bf7\u54a8\u8be2\u7814\u53d1\u7ec4" + idg.getClass().getName());
        }
        if (aep.isVersioned()) {
            attr = aep.getPropertyNames()[aep.getVersionProperty()];
            map.put("verName", attr);
            map.put("verColName", aep.getPropertyColumnNames(attr)[0]);
            map.put("verType", (Object)ColumnTypeEnum.toType(aep.getPropertyType(attr).getName()));
        }
        LinkedHashMap<String, Pair> columns = new LinkedHashMap<String, Pair>(8);
        map.put("columns", columns);
        HashMap<String, Pair> links = new HashMap<String, Pair>(1);
        map.put("links", links);
        HashMap<String, Pair> onetoone = new HashMap<String, Pair>(1);
        map.put("onetoone", onetoone);
        HashMap<String, Pair> onetomany = new HashMap<String, Pair>(1);
        map.put("onetomany", onetomany);
        for (String property : aep.getPropertyNames()) {
            Type type = aep.getPropertyType(property);
            if (type instanceof CollectionType || type instanceof OneToOneType) {
                String link;
                String linkEntity;
                Joinable ja;
                SessionFactoryImpl sf = this.sessionPool.getSessionFactory();
                if (type instanceof CollectionType) {
                    CollectionType st = (CollectionType)type;
                    ja = st.getAssociatedJoinable((SessionFactoryImplementor)sf);
                    linkEntity = st.getAssociatedEntityName((SessionFactoryImplementor)sf);
                } else {
                    OneToOneType st = (OneToOneType)type;
                    ja = st.getAssociatedJoinable((SessionFactoryImplementor)sf);
                    linkEntity = st.getAssociatedEntityName((SessionFactoryImplementor)sf);
                }
                String foreignKey = ja.getKeyColumnNames()[0];
                if (type instanceof OneToOneType) {
                    link = property;
                } else {
                    link = ja.getName().substring(entityName.length() + 1);
                    Map<String, Object> linkedMap = linkEntity.equals(entityName) ? map : this.getMetaData(linkEntity);
                    assert (linkedMap != null);
                    if (linkedMap.containsKey("associations")) {
                        pkfk = (HashMap)linkedMap.get("associations");
                        pkfk.put(entityName, new Pair(foreignKey, idType));
                    } else {
                        pkfk = new HashMap();
                        pkfk.put(entityName, new Pair(foreignKey, idType));
                        linkedMap.put("associations", pkfk);
                    }
                }
                links.put(link, new Pair(linkEntity, foreignKey));
                if (type instanceof CollectionType) {
                    onetomany.put(link, new Pair(linkEntity, foreignKey));
                    continue;
                }
                onetoone.put(link, new Pair(linkEntity, foreignKey));
                continue;
            }
            if (type instanceof ManyToOneType) continue;
            String columnName = aep.getPropertyColumnNames(property)[0];
            columns.put(property, new Pair(columnName, type.getName()));
        }
        EntityService.putMetaMapItem(entityName, map);
        return map;
    }

    public <T extends Serializable> T deepClone(T o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        return (T)((Serializable)o.getClass().cast(in.readObject()));
    }

    private void enchanceMetaData(Map<String, Object> pmd, String entityName) throws IOException, ClassNotFoundException {
        Map<String, Object> md = EntityService.getMetaMapItemByKey(entityName);
        HashMap links = (HashMap)md.get("links");
        HashMap plinks = (HashMap)pmd.get("links");
        for (String key : links.keySet()) {
            plinks.put(key, this.deepClone((Pair)links.get(key)));
        }
        LinkedHashMap sub = md.containsKey("subclasses") ? (LinkedHashMap)md.get("subclasses") : new LinkedHashMap();
        LinkedHashMap psub = pmd.containsKey("subclasses") ? (LinkedHashMap)pmd.get("subclasses") : new LinkedHashMap();
        for (String key : sub.keySet()) {
            psub.put(key, this.deepClone((SubClasses)sub.get(key)));
        }
        HashMap inv = (HashMap)md.get("inverses");
        HashMap pinv = (HashMap)pmd.get("inverses");
        for (String key : inv.keySet()) {
            pinv.put(key, (String)inv.get(key));
        }
        HashMap invid = md.containsKey("inverseid") ? (HashMap)md.get("inverseid") : new HashMap(0);
        HashMap<String, Pair> pinvid = pmd.containsKey("inverseid") ? (HashMap<String, Pair>)pmd.get("inverseid") : new HashMap<String, Pair>(invid.size());
        for (String key : invid.keySet()) {
            pinvid.put(key, this.deepClone((Pair)invid.get(key)));
        }
    }

    public JSONObject remoteDelete(String serviceName, String entityName, Object id) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.deleteById(entityName, String.valueOf(id), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteDeleteAllByIds(String serviceName, String entityName, JSONArray ids) {
        JSONObject params = new JSONObject();
        params.put("ids", (Object)ids);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.deleteAllByIds(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAllByIds(String serviceName, String columns, String entityName, JSONArray ids) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        params.put("ids", (Object)ids);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.findAllByIds(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAllByIds(String serviceName, String entityName, JSONArray ids) {
        return this.remoteFindAllByIds(serviceName, null, entityName, ids);
    }

    public JSONObject remoteGetCount(String serviceName, String entityName) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.getCount(entityName, "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAll(String serviceName, String columns, String entityName) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.findAll(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAll(String serviceName, String entityName) {
        return this.remoteFindAll(serviceName, "*", entityName);
    }

    public JSONObject remoteGetById(String serviceName, String columns, String entityName, Object id) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.getById(entityName, String.valueOf(id), params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteGetById(String serviceName, String entityName, Object id) {
        return this.remoteGetById(serviceName, "*", entityName, String.valueOf(id));
    }

    public JSONObject remoteSaveByKey(String serviceName, String entityName, JSONObject row, JSONArray keyArray, Boolean isCover) {
        JSONObject params = new JSONObject();
        params.put("entity", (Object)row);
        params.put("keyArray", (Object)keyArray);
        params.put("isCover", (Object)isCover);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.saveByKey(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteSaveByKey(String serviceName, String entityName, JSONObject row, JSONArray keyArray) {
        return this.remoteSaveByKey(serviceName, entityName, row, keyArray, true);
    }

    public JSONObject remotePartialSave(String serviceName, String entityName, JSONObject row) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.save(entityName, row.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remotePartialSave(String serviceName, String entityName, JSONArray rowArray) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.saveBatch(entityName, rowArray.toString(), "inner");
        return result.parseResponseJson();
    }
}

