/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import com.af.v4.system.common.jpa.action.MonitorInterceptor;
import com.af.v4.system.common.jpa.dialect.MyDialectResolver;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactoryImpl;
import com.af.v4.system.common.jpa.dynamic.DynamicTransactionManager;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.hibernate5.SpringSessionContext;

@Configuration
@ConfigurationProperties(prefix="spring.datasource")
public class HibernateConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateConfig.class);
    private final ApplicationContext context;
    private final ApplicationUtils applicationUtils;

    public HibernateConfig(ApplicationContext context) {
        this.context = context;
        this.applicationUtils = (ApplicationUtils)context.getBean(ApplicationUtils.class);
        DataSourceProperties dataSourceProperties = (DataSourceProperties)context.getBean(DataSourceProperties.class);
        dataSourceProperties.setType(HikariDataSource.class);
    }

    @Bean(name={"entityManagerFactory"})
    public DynamicSessionFactory dynamicSessionFactory() {
        Map dataSourceList = DynamicDataSource.getDataSourceMap();
        HashMap<Object, LocalSessionFactoryBean> sessionFactoryBeanMap = new HashMap<Object, LocalSessionFactoryBean>(dataSourceList.size());
        dataSourceList.forEach((key, value) -> {
            LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
            sessionFactoryBean.setDataSource((DataSource)value.getDataSource());
            sessionFactoryBean.setPackagesToScan(new String[]{"com.af.v4.entity." + key});
            Properties properties = this.getProperties((AfDataSourceWrapper)value);
            sessionFactoryBean.setHibernateProperties(properties);
            List cfgLocations = value.getConfig().getCfgLocations();
            if (cfgLocations != null && !cfgLocations.isEmpty()) {
                Resource[] cfgLocationResources = cfgLocations.stream().map(arg_0 -> ((ApplicationContext)this.context).getResource(arg_0)).toList().toArray(new Resource[cfgLocations.size()]);
                sessionFactoryBean.setConfigLocations(cfgLocationResources);
            }
            try {
                sessionFactoryBean.afterPropertiesSet();
            }
            catch (IOException e) {
                LOGGER.error("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
            }
            sessionFactoryBeanMap.put(key, sessionFactoryBean);
        });
        return new DynamicSessionFactoryImpl(sessionFactoryBeanMap, (LocalSessionFactoryBean)sessionFactoryBeanMap.get("master"));
    }

    private Properties getProperties(AfDataSourceWrapper wrapper) {
        boolean isClickhouse;
        AfDataSourceConfig value = wrapper.getConfig();
        Properties properties = new Properties();
        String hbm2dll = "none";
        properties.setProperty("hibernate.hbm2ddl.auto", hbm2dll);
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("hibernate.format_sql", "false");
        properties.setProperty("hibernate.current_session_context_class", SpringSessionContext.class.getName());
        properties.setProperty("hibernate.session_factory.statement_inspector", MonitorInterceptor.class.getName());
        properties.setProperty("hibernate.id.sequence.increment_size_mismatch_strategy", "LOG");
        if (value.getDialect() != null) {
            properties.setProperty("hibernate.dialect", value.getDialect());
        } else {
            properties.setProperty("hibernate.dialect_resolvers", MyDialectResolver.class.getCanonicalName());
        }
        boolean bl = isClickhouse = wrapper.getDbType() == DbType.clickhouse;
        if (isClickhouse) {
            properties.setProperty("hibernate.allow_update_outside_transaction", "true");
        }
        return properties;
    }

    @Bean
    public DynamicTransactionManager transactionManager() {
        DynamicTransactionManager transactionManager = new DynamicTransactionManager();
        transactionManager.setSessionFactory(this.dynamicSessionFactory());
        return transactionManager;
    }
}

