package com.af.v4.system.common.jpa.utils;

import com.af.v4.system.common.jpa.enums.ColumnTypeEnum;

import java.io.Serial;
import java.io.Serializable;

/**
 * Pair
 *
 * @author LocalUser
 */
public class Pair implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    public String col;
    public ColumnTypeEnum type;

    public Pair() {

    }


    public Pair(String col, ColumnTypeEnum type) {
        this.col = col;
        this.type = type;
    }

    public Pair(String col, String type) {
        this.col = col;
        this.type = ColumnTypeEnum.toType(type);
    }

    public String getCol() {
        return col;
    }

    public ColumnTypeEnum getType() {
        return type;
    }

    @Override
    public String toString() {
        return "(" + this.col + ":" + this.type + ")";
    }
}

