package com.af.v4.system.common.jpa.dialect;

import com.af.v4.system.common.core.constant.HttpStatus;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmDialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;

/**
 * 自定义方言解析器
 */
public final class MyDialectResolver implements DialectResolver {

    @Override
    public Dialect resolveDialect(DialectResolutionInfo info) {
        // clickhouse特殊处理
        if (info.getDatabaseName().contains("ClickHouse")) {
            return new MyClickHouseDialect();
        } else if (info.getDatabaseName().contains("Dm")) {
            return new DmDialect();
        }

        // hibernate默认方言处理
        for (Database database : Database.values()) {
            if (database == Database.SQLSERVER) {
                String version = info.getDatabaseVersion();
                if (version.contains("Microsoft SQL Server 2008")) {
                    return new SQLServer2008Dialect();
                }
                return new SQLServer2016Dialect();
            } else if (database == Database.ORACLE) {
                if (info.getDatabaseVersion().startsWith("Oracle Database 11g")) {
                    return new Oracle11Dialect();
                }
            } else if (database.matchesResolutionInfo(info)) {
                return database.createDialect(info);
            }
        }

        throw new ServiceException("数据源[" + DynamicDataSource.getDataSource() + "]方言不支持！", HttpStatus.CONFIG_ERROR);
    }
}
