/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.dialect;

import java.util.Locale;
import org.hibernate.LockOptions;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;

public class Oracle11LimitHandler
extends AbstractLimitHandler {
    private boolean bindLimitParametersInReverseOrder;
    private boolean useMaxForLimit;
    private boolean supportOffset;
    public static final Oracle11LimitHandler INSTANCE = new Oracle11LimitHandler();

    Oracle11LimitHandler() {
    }

    public String processSql(String sql, Limit limit, QueryOptions queryOptions) {
        return this.processSql(sql, Oracle11LimitHandler.hasFirstRow((Limit)limit), Oracle11LimitHandler.hasMaxRows((Limit)limit), queryOptions.getLockOptions());
    }

    protected String processSql(String sql, boolean hasFirstRow, boolean hasMaxRows, LockOptions lockOptions) {
        return this.processSql(sql, this.getForUpdateIndex(sql), hasFirstRow, hasMaxRows);
    }

    protected String processSql(String sql, int forUpdateIndex, boolean hasFirstRow, boolean hasMaxRows) {
        StringBuilder pagingSelect;
        this.bindLimitParametersInReverseOrder = true;
        this.useMaxForLimit = true;
        this.supportOffset = false;
        String forUpdateClause = null;
        boolean isForUpdate = false;
        if (forUpdateIndex > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        int forUpdateClauseLength = forUpdateClause == null ? 0 : forUpdateClause.length() + 1;
        if (hasFirstRow && hasMaxRows) {
            pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
            pagingSelect.append("select * from (select row_.*,rownum rownum_ from (");
            pagingSelect.append(sql);
            pagingSelect.append(") row_ where rownum<=?) where rownum_>?");
        } else if (hasFirstRow) {
            pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
            pagingSelect.append("select * from (");
            pagingSelect.append(sql);
            pagingSelect.append(") row_ where rownum>?");
        } else {
            pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 37);
            pagingSelect.append("select * from (");
            pagingSelect.append(sql);
            pagingSelect.append(") where rownum<=?");
        }
        if (isForUpdate) {
            pagingSelect.append(" ");
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    private int getForUpdateIndex(String sql) {
        int forUpdateLastIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for update");
        int lastIndexOfQuote = sql.lastIndexOf(39);
        if (forUpdateLastIndex > -1) {
            if (lastIndexOfQuote == -1) {
                return forUpdateLastIndex;
            }
            if (lastIndexOfQuote > forUpdateLastIndex) {
                return -1;
            }
            return forUpdateLastIndex;
        }
        return forUpdateLastIndex;
    }

    public final boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffset() {
        return this.supportOffset;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return this.bindLimitParametersInReverseOrder;
    }

    public boolean useMaxForLimit() {
        return this.useMaxForLimit;
    }
}

