package com.af.v4.system.common.jpa.action;

import com.af.v4.system.common.core.constant.CodeNormsConstants;
import com.af.v4.system.common.datasource.DynamicDataSource;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 监控拦截器
 */
@Component
public class MonitorInterceptor implements StatementInspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorInterceptor.class);

    @Override
    public String inspect(String sql) {

        if (DynamicDataSource.getDbType().dialect.isMySqlFamily()){
            sql = DynamicDataSource.getDbType().dialect.trans(sql);
        }

        LOGGER.info(CodeNormsConstants.DEBUG_PREFIX + "执行原生SQL：{\n{}\n}", sql);
        return sql;
    }
}
