package com.af.v4.system.common.jpa.enums;

/**
 * 表分片策略枚举
 */
public enum TableShardingStrategyEnum {
    /**
     * 不分表
     */
    NONE(""),

    /**
     * 按年分表，例如：t_table_2025
     */
    YEAR("yyyy"),

    /**
     * 按年月分表，例如：t_table_202503
     */
    MONTH("yyyyMM"),

    /**
     * 按年月日分表，例如：t_table_20250309
     */
    DAY("yyyyMMdd");

    private final String format;

    TableShardingStrategyEnum(String format) {
        this.format = format;
    }

    /**
     * 根据格式字符串获取枚举值
     *
     * @param format 格式字符串
     * @return 枚举值
     */
    public static TableShardingStrategyEnum fromFormat(String format) {
        if (format == null || format.isEmpty()) {
            return NONE;
        }

        for (TableShardingStrategyEnum strategy : values()) {
            if (strategy.getFormat().equals(format)) {
                return strategy;
            }
        }

        return NONE;
    }

    public String getFormat() {
        return format;
    }
}
