/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.config.DynamicDataSourceConfig;
import com.af.v4.system.common.jpa.enums.ColumnTypeEnum;
import com.af.v4.system.common.jpa.enums.IDTypeEnum;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.jpa.types.MetaData;
import com.af.v4.system.common.jpa.types.Pair;
import com.af.v4.system.common.jpa.types.SubClasses;
import com.af.v4.system.common.plugins.io.IOTools;
import jakarta.annotation.PostConstruct;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.uuid.UuidGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MetaDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataService.class);
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private static final Map<String, Map<String, MetaData>> META_MAP = new ConcurrentHashMap<String, Map<String, MetaData>>();
    private static final Map<String, Map<String, String>> ENTITY_LIFT_MAP = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, String> SENSITIVE_MASK_MAP = new ConcurrentHashMap<String, String>();
    private static volatile Boolean isAllMetaDataLoaded = false;
    private final DynamicDataSourceConfig dynamicDataSourceConfig;
    private final SessionPool sessionPool;

    public MetaDataService(DynamicDataSourceConfig dynamicDataSourceConfig, SessionPool sessionPool) {
        this.dynamicDataSourceConfig = dynamicDataSourceConfig;
        this.sessionPool = sessionPool;
    }

    public Metadata getHibernateMetadata() {
        return this.sessionPool.getMetaData();
    }

    private Map<String, Map<String, String>> parseEntityMetaAttributes(String entityName) {
        HashMap<String, Map<String, String>> metaAttributesMap = new HashMap<String, Map<String, String>>();
        try {
            Metadata metadata = this.getHibernateMetadata();
            PersistentClass persistentClass = metadata.getEntityBinding(entityName);
            if (persistentClass != null) {
                for (Property property : persistentClass.getProperties()) {
                    Map<String, String> fieldMetaAttrs;
                    if (property.getMetaAttributes() == null || property.getMetaAttributes().isEmpty() || (fieldMetaAttrs = MetaDataService.getStringMap(property)).isEmpty()) continue;
                    metaAttributesMap.put(property.getName(), fieldMetaAttrs);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u5b9e\u4f53[{}]\u7684meta\u5c5e\u6027\u5931\u8d25", (Object)entityName, (Object)e);
        }
        return metaAttributesMap;
    }

    private static Map<String, String> getStringMap(Property property) {
        HashMap<String, String> fieldMetaAttrs = new HashMap<String, String>();
        for (Map.Entry metaEntry : property.getMetaAttributes().entrySet()) {
            String key = (String)metaEntry.getKey();
            MetaAttribute metaAttribute = (MetaAttribute)metaEntry.getValue();
            if (metaAttribute.getValues() == null || metaAttribute.getValues().isEmpty()) continue;
            String value = (String)metaAttribute.getValues().getFirst();
            fieldMetaAttrs.put(key, value);
        }
        return fieldMetaAttrs;
    }

    public static Map<String, String> getEntityLiftMap() {
        String dataSourceName = DynamicDataSource.getDataSource();
        return ENTITY_LIFT_MAP.computeIfAbsent(dataSourceName, k -> new ConcurrentHashMap());
    }

    public static Map<String, MetaData> getMetaMap() {
        String dataSourceName = DynamicDataSource.getDataSource();
        return META_MAP.computeIfAbsent(dataSourceName, k -> new ConcurrentHashMap());
    }

    public static Map<String, String> getSensitiveMaskMap() {
        return SENSITIVE_MASK_MAP;
    }

    public static String getEntityLiftValueByKey(String entityName) {
        return MetaDataService.getEntityLiftMap().get(entityName);
    }

    private static void putEntityLiftValue(String key, String value) {
        MetaDataService.getEntityLiftMap().put(key, value);
    }

    @PostConstruct
    public void init() {
        this.loadSubclassMap();
    }

    public MetaData getMetaMapItemByKey(String entityName) {
        MetaData result;
        if (MetaDataService.getMetaMap().containsKey(entityName)) {
            result = MetaDataService.getMetaMap().get(entityName);
        } else {
            result = this.getMetaData(entityName);
            MetaDataService.getMetaMap().put(entityName, result);
        }
        return result;
    }

    public void loadSubclassMap() {
        SAXReader reader = new SAXReader();
        IOTools.getStream((String)"subclass.xml", stream -> this.loadSubclass(reader, stream));
        List subClassList = this.dynamicDataSourceConfig.getSubClass();
        if (subClassList != null) {
            for (Object moduleName : subClassList) {
                if (!"".equals(moduleName)) {
                    moduleName = (String)moduleName + "/";
                }
                String finalModuleName = moduleName;
                IOTools.getStream((String)("/" + (String)moduleName + "subclass.xml"), stream -> this.loadSubclass(reader, stream), notFindPath -> LOGGER.warn("{}\u6a21\u5757\u4e0b\u65e0subclass.xml\u6587\u4ef6", (Object)finalModuleName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAllMetaData() {
        if (isAllMetaDataLoaded.booleanValue()) {
            return;
        }
        SYNC_LOCK.lock();
        try {
            if (isAllMetaDataLoaded.booleanValue()) {
                return;
            }
            Set dataSourceNameList = DynamicDataSource.getDataSourceMap().keySet();
            for (String dataSource : dataSourceNameList) {
                DynamicDataSource.withDataSource((String)dataSource, () -> this.sessionPool.getSessionFactory().getMetamodel().forEachEntityDescriptor(entityPersister -> this.getMetaMapItemByKey(entityPersister.getEntityName())));
            }
            isAllMetaDataLoaded = true;
        }
        finally {
            SYNC_LOCK.unlock();
        }
    }

    private void loadSubclass(SAXReader reader, InputStream input) {
        Document document;
        try {
            document = reader.read(input);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("entity");
        while (it.hasNext()) {
            Map<String, SubClasses> subclasses;
            Element elm = (Element)it.next();
            String entityName = elm.attribute("name").getValue();
            String parentEntity = elm.attribute("parentEntity").getValue();
            String discProperty = elm.attribute("discProperty").getValue();
            String discriminator = elm.attribute("discriminator").getValue();
            MetaData em = this.getMetaMapItemByKey(parentEntity);
            if (em.hasSubclasses()) {
                subclasses = em.getSubclasses();
            } else {
                subclasses = new LinkedHashMap<String, SubClasses>();
                em.setSubclasses(subclasses);
            }
            subclasses.put(entityName, new SubClasses(discProperty, discriminator));
            MetaDataService.putEntityLiftValue(entityName, parentEntity);
        }
    }

    private MetaData getMetaData(String entityName) {
        AbstractEntityPersister aep;
        MetaData map = new MetaData();
        map.setEntityName(entityName);
        MappingMetamodelImplementor metamodel = this.sessionPool.getSessionFactory().getMappingMetamodel();
        try {
            aep = (AbstractEntityPersister)metamodel.getEntityDescriptor(entityName);
        }
        catch (UnknownEntityTypeException e) {
            String dataSourceName = DynamicDataSource.getDataSource();
            throw new ServiceException("\u6570\u636e\u6e90[%s]\u83b7\u53d6\u5b9e\u4f53[%s]\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5Hibernate Mapping".formatted(dataSourceName, entityName), Integer.valueOf(500));
        }
        map.setTableName(aep.getTableName());
        String idPropName = aep.getIdentifierPropertyName();
        if (idPropName == null) {
            LOGGER.warn("\u505c\u6b62\u5904\u7406\u3010{}\u3011\u7684\u6620\u5c04\uff0c\u53ef\u80fd\u542b\u6709\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7ed3\u6784", (Object)entityName);
            return null;
        }
        map.setIdName(idPropName);
        String idColName = aep.getPropertyColumnNames(idPropName)[0];
        map.setIdColName(idColName);
        ColumnTypeEnum idType = ColumnTypeEnum.toType(aep.getIdentifierType().getName());
        map.setIdType(idType);
        Generator idg = aep.getGenerator();
        if (idg instanceof UUIDGenerator || idg instanceof UuidGenerator || idg instanceof UUIDHexGenerator || idg instanceof GUIDGenerator) {
            map.setIdGenerator(IDTypeEnum.ID_GUID);
        } else if (idg instanceof SequenceStyleGenerator) {
            SequenceStyleGenerator generator = (SequenceStyleGenerator)idg;
            String sequenceName = generator.getDatabaseStructure().getPhysicalName().render();
            map.setSequence(sequenceName);
            map.setIdGenerator(IDTypeEnum.ID_SEQ);
        } else if (idg instanceof IdentityGenerator) {
            map.setIdGenerator(IDTypeEnum.ID_AUTO);
        } else if (idg instanceof Assigned) {
            map.setIdGenerator(IDTypeEnum.ID_ASSIGNED);
        } else if (idg instanceof ForeignGenerator) {
            map.setIdGenerator(IDTypeEnum.ID_FOREIGNER);
        } else {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684Hibernate Id\u751f\u6210\u5668\u7c7b\u578b\uff0c\u8bf7\u54a8\u8be2\u7814\u53d1\u7ec4\uff1a%s".formatted(idg.getClass().getName()));
        }
        if (aep.isVersioned()) {
            String attr = aep.getPropertyNames()[aep.getVersionProperty()];
            map.setVerName(attr);
            map.setVerColName(aep.getPropertyColumnNames(attr)[0]);
            map.setVerType(ColumnTypeEnum.toType(aep.getPropertyType(attr).getName()));
        }
        LinkedHashMap<String, Pair> columns = new LinkedHashMap<String, Pair>(8);
        map.setColumns(columns);
        HashMap<String, Pair> links = new HashMap<String, Pair>(1);
        map.setLinks(links);
        HashMap<String, String> inverses = new HashMap<String, String>(1);
        map.setInverses(inverses);
        HashMap<String, Pair> inverseMap = new HashMap<String, Pair>(1);
        map.setInverseid(inverseMap);
        Map<String, Map<String, String>> metaAttributesMap = this.parseEntityMetaAttributes(entityName);
        if (!metaAttributesMap.isEmpty()) {
            map.setMetaAttributes(metaAttributesMap);
            Set<String> sensitiveFields = map.getSensitiveFieldNames();
            for (String fieldName : sensitiveFields) {
                String strategy = map.getSensitiveMaskStrategy(fieldName);
                if (strategy == null) continue;
                SENSITIVE_MASK_MAP.put(fieldName, strategy);
            }
        }
        for (String property : aep.getPropertyNames()) {
            Type type = aep.getPropertyType(property);
            if (type instanceof CollectionType || type instanceof OneToOneType) {
                String link;
                String linkEntity;
                Joinable ja;
                SessionFactoryImpl sf = this.sessionPool.getSessionFactory();
                if (type instanceof CollectionType) {
                    CollectionType st = (CollectionType)type;
                    ja = st.getAssociatedJoinable((SessionFactoryImplementor)sf);
                    linkEntity = st.getAssociatedEntityName((SessionFactoryImplementor)sf);
                } else {
                    OneToOneType st = (OneToOneType)type;
                    ja = st.getAssociatedJoinable((SessionFactoryImplementor)sf);
                    linkEntity = st.getAssociatedEntityName((SessionFactoryImplementor)sf);
                }
                String foreignKey = ja.getKeyColumnNames()[0];
                if (type instanceof OneToOneType) {
                    link = property;
                } else {
                    link = ja.getName().substring(entityName.length() + 1);
                    MetaData linkedMap = linkEntity.equals(entityName) ? map : this.getMetaMapItemByKey(linkEntity);
                    assert (linkedMap != null);
                    if (linkedMap.hasAssociations()) {
                        pkfk = linkedMap.getAssociations();
                        pkfk.put(entityName, new Pair(foreignKey, idType));
                    } else {
                        pkfk = new HashMap<String, Pair>();
                        pkfk.put(entityName, new Pair(foreignKey, idType));
                        linkedMap.setAssociations(pkfk);
                    }
                }
                links.put(link, new Pair(linkEntity, foreignKey));
                continue;
            }
            if (type instanceof ManyToOneType) {
                ManyToOneType mto = (ManyToOneType)type;
                String linkedEntity = mto.getAssociatedEntityName();
                String colName = mto.getAssociatedJoinable((SessionFactoryImplementor)this.sessionPool.getSessionFactory()).getKeyColumnNames()[0];
                inverses.put(property, linkedEntity);
                inverseMap.put(property, new Pair(colName, this.getMetaMapItemByKey(linkedEntity).getIdType()));
                continue;
            }
            String columnName = aep.getPropertyColumnNames(property)[0];
            columns.put(property, new Pair(columnName, ColumnTypeEnum.toType(type.getName())));
        }
        return map;
    }

    public void enchanceMetaData(MetaData pmd, String entityName) {
        MetaData md = this.getMetaMapItemByKey(entityName);
        Map<String, Pair> links = md.getLinks();
        Map<String, Pair> plinks = pmd.getLinks();
        plinks.putAll(links);
        Map<String, SubClasses> sub = md.hasSubclasses() ? md.getSubclasses() : new LinkedHashMap<String, SubClasses>();
        Map<String, SubClasses> psub = pmd.hasSubclasses() ? pmd.getSubclasses() : new LinkedHashMap<String, SubClasses>();
        for (String key : sub.keySet()) {
            psub.put(key, sub.get(key).copy());
        }
        Map<String, String> inv = md.getInverses();
        Map<String, String> pinv = pmd.getInverses();
        for (String key : inv.keySet()) {
            pinv.put(key, inv.get(key));
        }
        Map<String, Pair> invid = md.hasInverseIds() ? md.getInverseid() : new HashMap<String, Pair>(0);
        Map<String, Pair> pinvid = pmd.hasInverseIds() ? pmd.getInverseid() : new HashMap<String, Pair>(invid.size());
        for (String key : invid.keySet()) {
            pinvid.put(key, invid.get(key).copy());
        }
    }
}

