/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.utils;

import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.security.utils.SecurityUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DesensitizationTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DesensitizationTool.class);
    private final LiuLiConfigService liuLiConfigService;

    public DesensitizationTool(LiuLiConfigService liuLiConfigService) {
        this.liuLiConfigService = liuLiConfigService;
    }

    public JSONArray processEncryption(JSONArray jsonArray) {
        JSONArray result = new JSONArray();
        JSONObject desensitizationConfig = this.liuLiConfigService.get("desensitizationConfig");
        boolean isDesensitization = desensitizationConfig.optBoolean("isDesensitization", false);
        JSONArray field = desensitizationConfig.optJSONArray("field", new JSONArray());
        JSONArray userId = desensitizationConfig.optJSONArray("userId", new JSONArray());
        boolean isDesensitized = this.containsString(userId, String.valueOf(SecurityUtils.getLoginUser().getUserid()));
        LOGGER.info("SecurityUtils.getLoginUser()" + SecurityUtils.getLoginUser().getUserid());
        LOGGER.info("SecurityUtils.getLoginUser()" + SecurityUtils.getLoginUser().getUserid());
        LOGGER.info("isDesensitized" + isDesensitized + "===========>" + String.valueOf(desensitizationConfig));
        if (isDesensitization) {
            for (int z = 0; z < jsonArray.length(); ++z) {
                JSONObject json = jsonArray.getJSONObject(z);
                LOGGER.info("json1------->" + String.valueOf(json));
                for (String key : json.keySet()) {
                    if (isDesensitized || field.isEmpty()) continue;
                    for (int i = 0; i < field.length(); ++i) {
                        String row;
                        String rowKey = field.getString(i);
                        LOGGER.info("rowKey------->" + rowKey);
                        if (key.equals(rowKey) && !key.equals("f_user_phone")) {
                            row = json.optString(rowKey);
                            json.put(rowKey, (Object)this.maskUserName(row));
                            continue;
                        }
                        if (!key.equals(rowKey)) continue;
                        row = json.optString(rowKey);
                        json.put(rowKey, (Object)this.maskPhoneNumber(row));
                    }
                }
                LOGGER.info("json2------->" + String.valueOf(json));
                result.put((Object)json);
            }
            LOGGER.info("result------->" + String.valueOf(result));
            return result;
        }
        LOGGER.info("result=======>" + String.valueOf(result));
        return jsonArray;
    }

    private String maskUserName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        int length = name.length();
        StringBuilder masked = new StringBuilder();
        switch (length) {
            case 1: {
                return name;
            }
            case 2: {
                masked.append("*").append(name.charAt(1));
                break;
            }
            case 3: {
                masked.append(name.charAt(0)).append("*").append(name.charAt(2));
                break;
            }
            case 4: {
                masked.append(name.charAt(0)).append("**").append(name.charAt(3));
                break;
            }
            case 5: {
                masked.append(name.charAt(0)).append("***").append(name.charAt(4));
                break;
            }
            case 6: {
                masked.append(name.charAt(0)).append("****").append(name.charAt(5));
                break;
            }
            case 7: {
                masked.append(name.charAt(0)).append("*****").append(name.charAt(6));
                break;
            }
            case 8: {
                masked.append(name.charAt(0)).append("******").append(name.charAt(7));
                break;
            }
            default: {
                masked.append(name.charAt(0));
                for (int i = 1; i < length - 1; ++i) {
                    masked.append("*");
                }
                masked.append(name.charAt(length - 1));
            }
        }
        return masked.toString();
    }

    private boolean validatePhoneNumber(String phone) {
        if (phone == null || phone.trim().isEmpty()) {
            return false;
        }
        String pureNum = phone.replaceAll("[^0-9]", "");
        if (pureNum.matches("^1[3-9]\\d{9}$")) {
            return true;
        }
        Pattern landlinePattern = Pattern.compile("^0\\d{2,3}([\\-\\s]?)\\d{7,8}$");
        Matcher landlineMatcher = landlinePattern.matcher(phone);
        if (landlineMatcher.matches()) {
            return true;
        }
        return pureNum.length() >= 10 && pureNum.length() <= 11 && pureNum.startsWith("0") && pureNum.substring(1).matches("\\d{9,10}");
    }

    private String maskPhoneNumber(String phone) {
        if (phone == null || phone.trim().isEmpty() || !this.validatePhoneNumber(phone)) {
            return phone;
        }
        String pureNum = phone.replaceAll("[^0-9]", "");
        if (pureNum.matches("^1[3-9]\\d{9}$")) {
            return pureNum.substring(0, 3) + "****" + pureNum.substring(7);
        }
        Pattern landlinePattern = Pattern.compile("(0\\d{2,3})([\\-\\s]?)(\\d{7,8})");
        Matcher matcher = landlinePattern.matcher(phone);
        if (matcher.matches()) {
            String areaCode = matcher.group(1);
            String separator = matcher.group(2);
            String localNum = matcher.group(3);
            String maskedLocal = "****" + localNum.substring(localNum.length() - 4);
            return areaCode + separator + maskedLocal;
        }
        if (pureNum.startsWith("0")) {
            int areaCodeLen = pureNum.length() == 10 ? 3 : 4;
            String areaCode = pureNum.substring(0, areaCodeLen);
            String localNum = pureNum.substring(areaCodeLen);
            int hideLength = localNum.length() - 4;
            String hideStr = hideLength > 0 ? "*".repeat(hideLength) : "";
            String maskedLocal = hideStr + localNum.substring(localNum.length() - 4);
            return areaCode + maskedLocal;
        }
        return phone;
    }

    private boolean containsString(JSONArray jsonArray, String target) {
        if (jsonArray == null || target == null) {
            return false;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            String element;
            try {
                element = jsonArray.getString(i);
            }
            catch (JSONException e) {
                continue;
            }
            if (!target.equals(element)) continue;
            return true;
        }
        return false;
    }
}

