/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.action;

import com.af.v4.system.common.core.constant.CodeNormsConstants;
import com.af.v4.system.common.core.exception.CheckedException;
import com.af.v4.system.common.core.proxy.jpa.IQueryParamsProxy;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.jpa.transformer.StandardAliasTransformer;
import com.af.v4.system.common.jpa.utils.DesensitizationTool;
import com.af.v4.system.common.jpa.utils.QueryParams;
import java.lang.invoke.StringConcatFactory;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.TupleTransformer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class SqlAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlAction.class);
    private final SessionPool sessionPool;
    private DesensitizationTool desensitizationTool;

    public SqlAction(SessionPool sessionPool, DesensitizationTool desensitizationTool) {
        this.sessionPool = sessionPool;
        this.desensitizationTool = desensitizationTool;
    }

    public JSONArray query(String name, String sql, IQueryParamsProxy queryParams) {
        return (JSONArray)this.sqlMonitor(() -> {
            InnerSQLCall sqlCall = new InnerSQLCall(sql, queryParams, StandardAliasTransformer.INSTANCE);
            JSONArray array = sqlCall.doInHibernate(this.sessionPool.getSession());
            this.writeSqlResult(name, array);
            array = this.desensitizationTool.processEncryption(array);
            return array;
        }, name, queryParams);
    }

    public Integer exec(String name, String sql, String dataSource) {
        return (int)((Integer)this.sqlMonitor(() -> {
            Session session = this.sessionPool.getSession();
            NativeQuery queryObject = session.createNativeQuery(sql);
            return queryObject.executeUpdate();
        }, name, new QueryParams.Builder().dataSource(dataSource).build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sqlMonitor(Supplier<Object> supplier, String name, IQueryParamsProxy queryParams) {
        if (StringUtils.isEmpty((String)name)) {
            throw new CheckedException(CodeNormsConstants.E_01);
        }
        LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u6267\u884cSQL[{}]\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}"})), (Object)name, (Object)queryParams);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Object object = DynamicDataSource.withDataSource((String)queryParams.getDataSource(), supplier);
            return object;
        }
        finally {
            stopWatch.stop();
            long time = stopWatch.getTotalTimeMillis();
            LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"SQL[{}]\u8017\u65f6\uff1a{}ms"})), (Object)name, (Object)time);
        }
    }

    private void writeSqlResult(String name, JSONArray array) {
        Object result = array.toString();
        int length = ((String)result).length();
        if (length > 2000) {
            result = ((String)result).substring(0, 2000) + "...\u540e\u7eed\u8fd8\u6709" + (length - 2000) + "\u4e2a\u5b57\u7b26";
        }
        LOGGER.info((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"SQL[{}]\u67e5\u8be2\u7ed3\u679c: \n{}"})), (Object)name, result);
    }

    private record InnerSQLCall(String sql, IQueryParamsProxy queryParams, TupleTransformer<?> transformer) implements HibernateCallback<JSONArray>
    {
        public JSONArray doInHibernate(Session session) {
            NativeQuery q = session.createNativeQuery(this.sql);
            Integer pageNo = this.queryParams.getPageNo();
            Integer pageSize = this.queryParams.getPageSize();
            JSONObject parameterList = this.queryParams.getParameterList();
            if (parameterList != null) {
                for (String key : parameterList.keySet()) {
                    Object value = parameterList.get(key);
                    if (value instanceof JSONArray) {
                        JSONArray list = (JSONArray)value;
                        q.setParameter(key, (Object)list.toList());
                        continue;
                    }
                    if (value instanceof JSONObject) {
                        JSONObject object = (JSONObject)value;
                        q.setParameter(key, (Object)object.toMap());
                        continue;
                    }
                    q.setParameter(key, value);
                }
            }
            q.setTupleTransformer(this.transformer);
            try {
                List list;
                if (pageSize == null || pageSize <= 0) {
                    list = q.list();
                } else if (pageNo == null || pageNo < 0) {
                    list = q.setFirstResult(0).setMaxResults(pageSize.intValue()).list();
                } else {
                    int resolvedPageNo = pageNo > 0 ? pageNo - 1 : 0;
                    list = q.setFirstResult(resolvedPageNo * pageSize).setMaxResults(pageSize.intValue()).list();
                }
                return new JSONArray((Collection)list);
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }
}

