/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.enums;

public enum ColumnTypeEnum {
    COL_STRING("STRING"),
    COL_DATE("DATE"),
    COL_TIME("TIME"),
    COL_BOOLEAN("BOOLEAN"),
    COL_INTEGER("INTEGER"),
    COL_LONG("LONG"),
    COL_DOUBLE("DOUBLE"),
    COL_DECIMAL("DECIMAL"),
    COL_CLOB("CLOB"),
    COL_NOT_SUPPORTED("NOT_SUPPORTED");

    private final String value;

    private ColumnTypeEnum(String value) {
        this.value = value;
    }

    public static ColumnTypeEnum toType(String value) {
        return ColumnTypeEnum.normalizeType(value);
    }

    private static ColumnTypeEnum normalizeType(String type) {
        return switch (type = type.toLowerCase()) {
            case "string" -> COL_STRING;
            case "date" -> COL_DATE;
            case "time", "timestamp" -> COL_TIME;
            case "boolean", "yes_no" -> COL_BOOLEAN;
            case "integer" -> COL_INTEGER;
            case "big_integer", "long" -> COL_LONG;
            case "double" -> COL_DOUBLE;
            case "big_decimal" -> COL_DECIMAL;
            case "clob" -> COL_CLOB;
            default -> COL_NOT_SUPPORTED;
        };
    }

    public static boolean is(String value) {
        return ColumnTypeEnum.toType(value) != null;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

