package com.af.v4.system.common.jpa.types;

import com.af.v4.system.common.jpa.enums.ColumnTypeEnum;

import java.io.Serializable;

/**
 * Pair
 *
 * @author LocalUser
 */
public class Pair implements Serializable {

    public String col;
    public ColumnTypeEnum type;

    public Pair() {

    }


    public Pair(String col, ColumnTypeEnum type) {
        this.col = col;
        this.type = type;
    }

    public Pair(String col, String type) {
        this.col = col;
        this.type = ColumnTypeEnum.toType(type);
    }

    public String getCol() {
        return col;
    }

    public ColumnTypeEnum getType() {
        return type;
    }

    @Override
    public String toString() {
        return STR."(\{this.col}:\{this.type})";
    }

    public Pair copy() {
        return new Pair(this.col, this.type);
    }
}

