package com.af.v4.system.common.jpa.dynamic;

import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

/**
 * 动态数据源Session工厂
 */
public interface DynamicSessionFactory extends SessionFactory {

    /**
     * 获取SessionFactory
     *
     * @return SessionFactory
     */
    SessionFactory getHibernateSessionFactory();

    /**
     * 获取Configuration
     *
     * @return Configuration
     */
    Configuration getConfiguration();

    /**
     * 获取LocalSessionFactoryBean
     *
     * @return LocalSessionFactoryBean
     */
    LocalSessionFactoryBean getLocalSessionFactoryBean();

    /**
     * 获取Metadata
     *
     * @return Metadata
     */
    Metadata getMetadata();
}
