/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.utils;

import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import com.af.v4.system.common.jpa.action.MonitorInterceptor;
import com.af.v4.system.common.jpa.dialect.MyDialectResolver;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.hibernate5.SpringSessionContext;
import org.springframework.stereotype.Component;

@Component
public class SessionFactoryBeanBuilder {
    private final ApplicationContext context;

    public SessionFactoryBeanBuilder(ApplicationContext context) {
        this.context = context;
    }

    private static Properties getProperties(AfDataSourceWrapper wrapper) {
        boolean isClickhouse;
        AfDataSourceConfig value = wrapper.getConfig();
        Properties properties = new Properties();
        String hbm2dll = "none";
        properties.setProperty("hibernate.hbm2ddl.auto", hbm2dll);
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("hibernate.format_sql", "false");
        properties.setProperty("hibernate.current_session_context_class", SpringSessionContext.class.getName());
        properties.setProperty("hibernate.session_factory.statement_inspector", MonitorInterceptor.class.getName());
        properties.setProperty("hibernate.id.sequence.increment_size_mismatch_strategy", "LOG");
        if (value.getDialect() != null) {
            properties.setProperty("hibernate.dialect", value.getDialect());
        } else {
            properties.setProperty("hibernate.dialect_resolvers", MyDialectResolver.class.getCanonicalName());
        }
        boolean bl = isClickhouse = wrapper.getDbType() == DbType.clickhouse;
        if (isClickhouse) {
            properties.setProperty("hibernate.allow_update_outside_transaction", "true");
        }
        return properties;
    }

    public LocalSessionFactoryBean buildSessionFactory(String dataSourceName, AfDataSourceWrapper dataSourceWrapper) throws IOException {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource((DataSource)dataSourceWrapper.getDataSource());
        sessionFactoryBean.setPackagesToScan(new String[]{"com.af.v4.entity." + dataSourceName});
        Properties properties = SessionFactoryBeanBuilder.getProperties(dataSourceWrapper);
        sessionFactoryBean.setHibernateProperties(properties);
        List cfgLocations = dataSourceWrapper.getConfig().getCfgLocations();
        if (cfgLocations != null && !cfgLocations.isEmpty()) {
            Resource[] cfgLocationResources = cfgLocations.stream().map(arg_0 -> ((ApplicationContext)this.context).getResource(arg_0)).toList().toArray(new Resource[cfgLocations.size()]);
            sessionFactoryBean.setConfigLocations(cfgLocationResources);
        }
        sessionFactoryBean.afterPropertiesSet();
        return sessionFactoryBean;
    }
}

