/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.sensitive;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class SensitiveDataClassifier {
    private static final Pattern MASKED_PATTERN = Pattern.compile(".*\\*.*");
    private static final Pattern ENCRYPTED_PATTERN = Pattern.compile(".*\\|-.+-\\|.*");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("^\\s*$");
    private static final Set<String> NAME_FIELD_KEYWORDS = Set.of("name", "username", "realname", "nickname");
    private static final Set<String> PHONE_FIELD_KEYWORDS = Set.of("phone", "mobile", "tel", "telephone");
    private static final Set<String> ADDRESS_FIELD_KEYWORDS = Set.of("address", "addr", "location");
    private static final Set<String> ID_FIELD_KEYWORDS = Set.of("idnumber", "cardnumber", "idcard");

    private static boolean containsAnyKeyword(String fieldName, Set<String> keywords) {
        String lowerField = fieldName.toLowerCase();
        return keywords.stream().anyMatch(lowerField::contains);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean containsIdKeywords(String fieldName) {
        String lowerField = fieldName.toLowerCase();
        if (lowerField.contains("id")) {
            if (lowerField.contains("number")) return true;
            if (lowerField.contains("card")) return true;
        }
        if (!ID_FIELD_KEYWORDS.stream().anyMatch(lowerField::contains)) return false;
        return true;
    }

    public DataClassificationResult classify(String fieldName, Object value) {
        if (value == null) {
            return DataClassificationResult.nullValue();
        }
        String strValue = value.toString().trim();
        if (strValue.isEmpty()) {
            return DataClassificationResult.nullValue();
        }
        try {
            FieldType fieldType = FieldType.classify(fieldName);
            return switch (fieldType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.classifyValueByType(strValue, "\u7528\u6237\u540d");
                case 1 -> this.classifyValueByType(strValue, "\u624b\u673a\u53f7");
                case 2 -> this.classifyValueByType(strValue, "\u5730\u5740");
                case 3 -> this.classifyValueByType(strValue, "\u8eab\u4efd\u8bc1\u53f7");
                case 4 -> this.classifyValueByType(strValue, "\u901a\u7528\u5b57\u6bb5");
            };
        }
        catch (Exception e) {
            return DataClassificationResult.uncertain("\u5206\u7c7b\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
        }
    }

    private DataClassificationResult classifyValueByType(String value, String fieldType) {
        if (MASKED_PATTERN.matcher(value).matches()) {
            return DataClassificationResult.alreadyMasked(fieldType + "\u5305\u542b*\u7b26\u53f7");
        }
        if (ENCRYPTED_PATTERN.matcher(value).matches()) {
            return DataClassificationResult.alreadyEncrypted(fieldType + "\u52a0\u5bc6\u683c\u5f0f");
        }
        if (value.length() >= 2 && !WHITESPACE_PATTERN.matcher(value).matches()) {
            return DataClassificationResult.rawData(fieldType + "\u539f\u59cb\u6570\u636e");
        }
        return DataClassificationResult.uncertain(fieldType + "\u957f\u5ea6\u8fc7\u77ed\u6216\u5168\u4e3a\u7a7a\u683c");
    }

    public boolean isAlreadyProcessed(String value) {
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        DataClassificationResult result = this.classifyValueByType(value, "\u901a\u7528\u5b57\u6bb5");
        return !result.needsProcessing();
    }

    public static sealed interface DataClassificationResult {
        public boolean needsProcessing();

        public String getDescription();

        public static RawData rawData() {
            return new RawData();
        }

        public static RawData rawData(String reason) {
            return new RawData(reason);
        }

        public static AlreadyMasked alreadyMasked() {
            return new AlreadyMasked();
        }

        public static AlreadyMasked alreadyMasked(String pattern) {
            return new AlreadyMasked(pattern);
        }

        public static AlreadyEncrypted alreadyEncrypted() {
            return new AlreadyEncrypted();
        }

        public static AlreadyEncrypted alreadyEncrypted(String format) {
            return new AlreadyEncrypted(format);
        }

        public static NullValue nullValue() {
            return new NullValue();
        }

        public static Uncertain uncertain() {
            return new Uncertain();
        }

        public static Uncertain uncertain(String reason) {
            return new Uncertain(reason);
        }

        public record RawData(String reason) implements DataClassificationResult
        {
            public RawData() {
                this("\u68c0\u6d4b\u5230\u539f\u59cb\u654f\u611f\u6570\u636e");
            }

            @Override
            public boolean needsProcessing() {
                return true;
            }

            @Override
            public String getDescription() {
                return this.reason;
            }
        }

        public record AlreadyMasked(String pattern) implements DataClassificationResult
        {
            public AlreadyMasked() {
                this("\u5305\u542b\u8131\u654f\u6807\u8bc6\u7b26(*)");
            }

            @Override
            public boolean needsProcessing() {
                return false;
            }

            @Override
            public String getDescription() {
                return "\u5df2\u8131\u654f: " + this.pattern;
            }
        }

        public record AlreadyEncrypted(String format) implements DataClassificationResult
        {
            public AlreadyEncrypted() {
                this("\u683c\u5f0f: |-...-|");
            }

            @Override
            public boolean needsProcessing() {
                return false;
            }

            @Override
            public String getDescription() {
                return "\u5df2\u52a0\u5bc6: " + this.format;
            }
        }

        public record NullValue() implements DataClassificationResult
        {
            @Override
            public boolean needsProcessing() {
                return false;
            }

            @Override
            public String getDescription() {
                return "\u7a7a\u503c\u6216\u7a7a\u5b57\u7b26\u4e32";
            }
        }

        public record Uncertain(String reason) implements DataClassificationResult
        {
            public Uncertain() {
                this("\u65e0\u6cd5\u786e\u5b9a\u6570\u636e\u7c7b\u578b");
            }

            @Override
            public boolean needsProcessing() {
                return false;
            }

            @Override
            public String getDescription() {
                return "\u4e0d\u786e\u5b9a: " + this.reason;
            }
        }
    }

    private static enum FieldType {
        NAME(field -> SensitiveDataClassifier.containsAnyKeyword(field, NAME_FIELD_KEYWORDS)),
        PHONE(field -> SensitiveDataClassifier.containsAnyKeyword(field, PHONE_FIELD_KEYWORDS)),
        ADDRESS(field -> SensitiveDataClassifier.containsAnyKeyword(field, ADDRESS_FIELD_KEYWORDS)),
        ID_NUMBER(SensitiveDataClassifier::containsIdKeywords),
        GENERIC(field -> true);

        private final Predicate<String> matcher;

        private FieldType(Predicate<String> matcher) {
            this.matcher = matcher;
        }

        boolean matches(String fieldName) {
            return this.matcher.test(fieldName.toLowerCase());
        }

        static FieldType classify(String fieldName) {
            return Arrays.stream(FieldType.values()).filter(type -> type.matches(fieldName)).findFirst().orElse(GENERIC);
        }
    }
}

