/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.jpa.action.SqlAction;
import com.af.v4.system.common.jpa.utils.QueryParams;
import com.af.v4.system.common.resource.mapper.PluginMapper;
import com.af.v4.system.common.resource.mapper.SqlMapper;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlService.class);
    private final SqlMapper sqlMapper;
    private final SqlAction sqlAction;
    private final ApplicationService applicationService;

    public SqlService(SqlMapper sqlMapper, SqlAction sqlAction, ApplicationService applicationService) {
        this.sqlMapper = sqlMapper;
        this.sqlAction = sqlAction;
        this.applicationService = applicationService;
    }

    public String getSQL(String name, JSONObject params) {
        return this.getSQLByFile(name, params);
    }

    public JSONObject queryTotal(String name, JSONObject params, String dataSourceName) {
        Object sums = null;
        if (params.has("sums")) {
            sums = params.get("sums");
        }
        String sql = this.getSQLByFile(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        QueryParams queryParams = new QueryParams.Builder().dataSource(dataSourceName).build();
        JSONArray array = this.sqlAction.query(name, sql, queryParams);
        return array.getJSONObject(0);
    }

    public JSONObject queryTotal(String name, JSONObject params) {
        return this.queryTotal(name, params, null);
    }

    public JSONObject queryTotal(String name, String str, String dataSourceName) {
        return this.queryTotal(name, StringUtils.isEmpty((String)str) ? new JSONObject() : new JSONObject(str), dataSourceName);
    }

    public JSONObject queryTotal(String name, String str) {
        return this.queryTotal(name, str, null);
    }

    public JSONArray query(String name, JSONObject params, Integer pageNo, Integer pageSize, String dataSourceName) {
        String sql = this.getSQLByFile(name, params);
        QueryParams queryParams = new QueryParams.Builder().pageNo(pageNo).pageSize(pageSize).dataSource(dataSourceName).build();
        return this.sqlAction.query(name, sql, queryParams);
    }

    public JSONArray query(String name, JSONObject params, Integer pageNo, Integer pageSize) {
        return this.query(name, params, pageNo, pageSize, null);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize, String dataSourceName) {
        return this.query(name, params, 1, pageSize, dataSourceName);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) {
        return this.query(name, params, (Integer)1, pageSize);
    }

    public JSONArray query(String name, JSONObject params, String dataSourceName) {
        return this.query(name, params, null, null, dataSourceName);
    }

    public JSONArray query(String name, JSONObject params) {
        return this.query(name, params, null, null, null);
    }

    @Deprecated(since="2.8.0")
    public JSONArray querySQL(String name, String sql, String dataSourceName) {
        QueryParams queryParams = new QueryParams.Builder().dataSource(dataSourceName).build();
        return this.querySQL(name, sql, queryParams);
    }

    public JSONArray querySQL(String name, String sql) {
        QueryParams queryParams = new QueryParams.Builder().build();
        return this.querySQL(name, sql, queryParams);
    }

    @Deprecated(since="2.8.0")
    public JSONArray querySQL(String name, String sql, Integer pageSize, String dataSourceName) {
        QueryParams queryParams = new QueryParams.Builder().pageSize(pageSize).dataSource(dataSourceName).build();
        return this.querySQL(name, sql, queryParams);
    }

    @Deprecated(since="2.8.0")
    public JSONArray querySQL(String name, String sql, Integer pageSize) {
        QueryParams queryParams = new QueryParams.Builder().pageSize(pageSize).build();
        return this.querySQL(name, sql, queryParams);
    }

    @Deprecated(since="2.8.0")
    public JSONArray querySQL(String name, String sql, Integer pageNo, Integer pageSize, String dataSourceName) {
        QueryParams queryParams = new QueryParams.Builder().pageNo(pageNo).pageSize(pageSize).dataSource(dataSourceName).build();
        return this.querySQL(name, sql, queryParams);
    }

    @Deprecated(since="2.8.0")
    public JSONArray querySQL(String name, String sql, Integer pageNo, Integer pageSize) {
        QueryParams queryParams = new QueryParams.Builder().pageNo(pageNo).pageSize(pageSize).build();
        return this.querySQL(name, sql, queryParams);
    }

    public JSONArray querySQL(String name, String sql, JSONObject queryParamsObj) {
        QueryParams queryParams = QueryParams.Builder.fromJSONObject(queryParamsObj).build();
        return this.sqlAction.query(name, sql, queryParams);
    }

    public JSONArray querySQL(String name, String sql, QueryParams queryParams) {
        return this.sqlAction.query(name, sql, queryParams);
    }

    public Integer exec(String name, JSONObject params, String dataSourceName) {
        String sql = this.getSQLByFile(name, params);
        return this.execSQL(name, sql, dataSourceName);
    }

    public Integer exec(String name, JSONObject params) {
        return this.exec(name, params, null);
    }

    public Integer execSQL(String name, String sql, String dataSourceName) {
        return this.sqlAction.exec(name, sql, dataSourceName);
    }

    public Integer execSQL(String name, String sql) {
        return this.execSQL(name, sql, null);
    }

    private String getSQLByFile(String sqlName, JSONObject params) {
        SqlMapper.SqlResource resource = (SqlMapper.SqlResource)this.sqlMapper.getResource(sqlName);
        String source = resource.getSource();
        params.put("ENV", (Object)this.applicationService.getValues());
        params.put("RESOURCE", (Object)resource.getJsonParams());
        PluginMapper.getPluginMap().forEach((arg_0, arg_1) -> ((JSONObject)params).put(arg_0, arg_1));
        return Expression.run((String)source, (Map)params.toMap()).toString();
    }

    private String filterOutOrderBy(String source, Object sums) {
        int idx = source.toLowerCase().lastIndexOf("order by");
        if (idx == -1) {
            idx = source.length() - 1;
        }
        StringBuilder sql = new StringBuilder("select ");
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql.append("sum(").append(name).append(") ").append(name).append(", ");
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql.append("sum(").append(value).append(") ").append(name).append(", ");
                }
            }
        }
        if (idx != -1) {
            sql.append("count(*) n, 1 placeholder from ( ").append(source, 0, idx).append(") t_");
        }
        return sql.toString();
    }

    public String getDbTypeName() {
        return DynamicDataSource.getDbType().name();
    }

    public String resolveSQL(JSONObject sqlList) {
        String dbType = this.getDbTypeName();
        String sqlStr = sqlList.optString(dbType, null);
        if (sqlStr == null) {
            throw new ServiceException("\u672a\u627e\u5230\u7b26\u5408\u6570\u636e\u6e90[" + dbType + "]\u7684SQL");
        }
        return sqlStr;
    }
}

