/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.StrUtil;
import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.jpa.IEntityServiceProxy;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.enums.DbType;
import com.af.v4.system.common.jpa.action.SqlAction;
import com.af.v4.system.common.jpa.enums.ColumnTypeEnum;
import com.af.v4.system.common.jpa.enums.IDTypeEnum;
import com.af.v4.system.common.jpa.enums.TableShardingStrategyEnum;
import com.af.v4.system.common.jpa.service.ClickhouseService;
import com.af.v4.system.common.jpa.service.MetaDataService;
import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.system.common.jpa.types.MetaData;
import com.af.v4.system.common.jpa.types.Pair;
import com.af.v4.system.common.jpa.types.SubClasses;
import com.af.v4.system.common.jpa.utils.Condition;
import com.af.v4.system.common.jpa.utils.QueryParams;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service
@Transactional(rollbackFor={Exception.class})
public class EntityService
implements IEntityServiceProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityService.class);
    private final SessionPool sessionPool;
    private final SqlAction sqlAction;
    private final DynamicFeignClientFactory<RemoteEntityService> dynamicFeignClientFactory;
    private final ClickhouseService clickhouseService;
    private final MetaDataService metaDataService;

    public EntityService(SessionPool sessionPool, SqlAction sqlAction, DynamicFeignClientFactory<RemoteEntityService> dynamicFeignClientFactory, ClickhouseService clickhouseService, MetaDataService metaDataService) {
        this.sessionPool = sessionPool;
        this.sqlAction = sqlAction;
        this.dynamicFeignClientFactory = dynamicFeignClientFactory;
        this.clickhouseService = clickhouseService;
        this.metaDataService = metaDataService;
    }

    private String getTableNameWithSharding(String baseTableName, String shardingStrategy) {
        if (StrUtil.isBlank((CharSequence)shardingStrategy)) {
            return baseTableName;
        }
        TableShardingStrategyEnum strategy = TableShardingStrategyEnum.fromFormat(shardingStrategy);
        if (strategy == TableShardingStrategyEnum.NONE) {
            return baseTableName;
        }
        String suffix = DateUtil.format((Date)new Date(), (String)strategy.getFormat());
        return baseTableName + "_" + suffix;
    }

    public static Condition getCondition() {
        return Condition.build();
    }

    public JSONObject getById(String columns, String entityName, Object id, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String sql = "SELECT " + columns + " FROM " + map.getTableName() + " WHERE " + map.getIdColName() + " = '" + String.valueOf(id) + "'";
        JSONArray result = this.sqlAction.query("EntityService@getById", sql, new QueryParams.Builder().dataSource(dataSourceName).build());
        if (result.isEmpty()) {
            return null;
        }
        return result.getJSONObject(0);
    }

    public JSONObject getById(String columns, String entityName, Object id) {
        return this.getById(columns, entityName, id, null);
    }

    public JSONObject getById(String entityName, Object id) {
        return this.getById("*", entityName, String.valueOf(id));
    }

    public JSONArray getByCondition(String columns, String entityName, Condition condition, String order, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String sql = "SELECT " + columns + " FROM " + map.getTableName() + " WHERE " + condition.getValue();
        if (order != null) {
            sql = sql + " ORDER BY " + order;
        }
        return this.sqlAction.query("EntityService@getByCondition", sql, new QueryParams.Builder().dataSource(dataSourceName).build());
    }

    public JSONArray getByCondition(String columns, String entityName, Condition condition, String order) {
        return this.getByCondition(columns, entityName, condition, order, null);
    }

    public JSONArray getByCondition(String columns, String entityName, Condition condition) {
        return this.getByCondition(columns, entityName, condition, null);
    }

    public JSONArray getByCondition(String entityName, Condition condition) {
        return this.getByCondition("*", entityName, condition, null);
    }

    public JSONArray getByCondition(String entityName, Condition condition, String order) {
        return this.getByCondition("*", entityName, condition, order);
    }

    public Integer delete(String entityName, Object id, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String sql = "DELETE FROM " + map.getTableName() + " WHERE " + map.getIdColName() + " = '" + String.valueOf(id) + "'";
        return this.sqlAction.exec("EntityService@Delete", sql, dataSourceName);
    }

    public Integer delete(String entityName, Object id) {
        return this.delete(entityName, id, null);
    }

    public Integer deleteAllByIds(String entityName, JSONArray ids, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String idStr = CommonTools.union((JSONArray)ids);
        String sql = "DELETE FROM " + map.getTableName() + " WHERE " + map.getIdColName() + " IN (" + idStr + " )";
        return this.sqlAction.exec("EntityService@deleteAllByIds", sql, dataSourceName);
    }

    public Integer deleteAllByIds(String entityName, JSONArray ids) {
        return this.deleteAllByIds(entityName, ids, null);
    }

    public JSONArray findAllByIds(String columns, String entityName, JSONArray ids, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String idStr = CommonTools.union((JSONArray)ids);
        String sql = "SELECT " + columns + " FROM " + map.getTableName() + " WHERE " + map.getIdColName() + " IN (" + idStr + " )";
        return this.sqlAction.query("EntityService@findAllByIds", sql, new QueryParams.Builder().dataSource(dataSourceName).build());
    }

    public JSONArray findAllByIds(String columns, String entityName, JSONArray ids) {
        return this.findAllByIds(columns, entityName, ids, null);
    }

    public JSONArray findAllByIds(String entityName, JSONArray ids) {
        return this.findAllByIds("*", entityName, ids);
    }

    public Long getCount(String entityName, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String sql = "SELECT COUNT(0) count FROM " + map.getTableName();
        JSONArray result = this.sqlAction.query("EntityService@getCount", sql, new QueryParams.Builder().dataSource(dataSourceName).build());
        return !result.isEmpty() ? result.getJSONObject(0).getLong("count") : 0L;
    }

    public Long getCount(String entityName) {
        return this.getCount(entityName, null);
    }

    public JSONArray findAll(String columns, String entityName, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String sql = "SELECT " + columns + " FROM " + map.getTableName();
        return this.sqlAction.query("EntityService@findAll", sql, new QueryParams.Builder().dataSource(dataSourceName).build());
    }

    public JSONArray findAll(String columns, String entityName) {
        return this.findAll(columns, entityName, null);
    }

    public JSONArray findAll(String entityName) {
        return this.findAll("*", entityName);
    }

    public JSONObject saveByKey(String entityName, JSONObject row, JSONArray keyArray, Boolean isCover, String dataSourceName) {
        Condition condition = Condition.build();
        int keyArrayLength = keyArray.length();
        for (int i = 0; i < keyArrayLength; ++i) {
            String keyName = keyArray.getString(i);
            condition = condition.eq(keyName, row.get(keyName));
            if (i >= keyArrayLength - 1) continue;
            condition.and();
        }
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String idName = map.getIdColName();
        JSONArray entityDataList = this.getByCondition(idName, entityName, condition);
        int entityDataLength = entityDataList.length();
        if (entityDataLength == 1) {
            if (!isCover.booleanValue()) {
                throw new ServiceException("\u5b9e\u4f53[" + entityName + "]\u5bf9\u5e94\u7684\u6570\u636e\u5df2\u5b58\u5728", Integer.valueOf(400));
            }
            row.put(idName, entityDataList.getJSONObject(0).get(idName));
        } else {
            if (entityDataLength > 1) {
                throw new ServiceException("\u5b9e\u4f53[" + entityName + "]\u5bf9\u5e94\u7684\u6570\u636e\u6761\u6570\u6709\u8bef\uff0c\u9884\u671f\uff1a1\uff0c\u5b9e\u9645\uff1a" + entityDataLength, Integer.valueOf(400));
            }
            row.remove(idName);
        }
        return this.partialSave(entityName, row, dataSourceName);
    }

    public JSONObject saveByKey(String entityName, JSONObject row, JSONArray keyArray, Boolean isCover) {
        return this.saveByKey(entityName, row, keyArray, isCover, null);
    }

    public JSONObject saveByKey(String entityName, JSONObject row, JSONArray keyArray) {
        return this.saveByKey(entityName, row, keyArray, true);
    }

    public JSONArray overrideSave(String entityName, JSONArray rowArray, String foreignName, Object foreignId, String dataSourceName) {
        this.sqlAction.exec("EntityService@doDelete", "DELETE FROM " + entityName + " WHERE" + foreignName + " = " + String.valueOf(foreignId), dataSourceName);
        return this.partialSave(entityName, rowArray, dataSourceName);
    }

    public JSONArray overrideSave(String entityName, JSONArray rowArray, String foreignName, Object foreignId) {
        return this.overrideSave(entityName, rowArray, foreignName, foreignId, null);
    }

    public String getTablePrimaryKey(String entityName) {
        return this.metaDataService.getMetaMapItemByKey(entityName).getIdColName();
    }

    public JSONObject partialSave(String entityName, JSONObject row, String dataSourceName) {
        return this.partialSave(entityName, new JSONArray().put((Object)row), dataSourceName).getJSONObject(0);
    }

    public JSONObject partialSave(String entityName, JSONObject row) {
        return this.partialSave(entityName, row, null);
    }

    public JSONArray partialSave(String entityName, JSONArray rowArray, String dataSourceName) {
        JSONArray result;
        DbType dbType = DynamicDataSource.getDbType();
        if (dbType == DbType.clickhouse) {
            result = new JSONArray();
            this.clickhouseService.save(entityName, rowArray);
        } else {
            MetaData md;
            if (MetaDataService.getEntityLiftMap().containsKey(entityName)) {
                String pEntityName = MetaDataService.getEntityLiftValueByKey(entityName);
                md = this.metaDataService.getMetaMapItemByKey(pEntityName).copy();
                this.metaDataService.enchanceMetaData(md, entityName);
            } else {
                md = this.metaDataService.getMetaMapItemByKey(entityName);
            }
            List<Serializable> aid = this.partialSave(rowArray, md, null, null, dataSourceName);
            result = new JSONArray(aid.size());
            aid.forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put(md.getIdColName(), (Object)item.toString());
                result.put((Object)obj);
            });
        }
        return result;
    }

    public JSONArray partialSave(String entityName, JSONArray rowArray) {
        return this.partialSave(entityName, rowArray, null);
    }

    private void partialSave(JSONObject row, MetaData md, Object pIdValue, String pEntityName, String dataSourceName) {
        JSONArray array = new JSONArray(1);
        array.put((Object)row);
        this.partialSave(array, md, pIdValue, pEntityName, dataSourceName);
    }

    private List<Serializable> partialSave(JSONArray rowArray, MetaData md, Object pIdValue, String pEntityName, String dataSourceName) {
        ArrayList<Serializable> result = new ArrayList<Serializable>(rowArray.length());
        rowArray.forEach(item -> {
            int affectedRows;
            JSONObject row = (JSONObject)item;
            Object idValue = null;
            String idName = md.getIdColName();
            ColumnTypeEnum idType = md.getIdType();
            if (row.has(idName)) {
                idValue = row.get(idName);
            }
            Map<String, Pair> columns = md.getColumns();
            Map<String, Pair> links = md.getLinks();
            boolean isInsert = false;
            if (idValue == null || idValue == JSONObject.NULL) {
                affectedRows = this.doInsert(row, md, pIdValue, pEntityName, idName, idType, columns, dataSourceName);
            } else if (md.getIdGenerator() != IDTypeEnum.ID_ASSIGNED) {
                affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, idValue, idType, columns, dataSourceName);
            } else if (this.hasRow(md.getTableName(), md.getIdColName(), idValue, idType, dataSourceName)) {
                affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, idValue, idType, columns, dataSourceName);
            } else {
                isInsert = true;
                affectedRows = this.doInsert(row, md, pIdValue, pEntityName, idName, idType, columns, dataSourceName);
            }
            if (affectedRows == 0) {
                throw new ServiceException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u5f71\u54cd\u884c\u6570\u4e3a:0", Integer.valueOf(400));
            }
            idValue = row.get(idName);
            if (isInsert) {
                row.remove(idName);
            }
            Iterator itr = row.keys();
            while (itr.hasNext()) {
                String attr = (String)itr.next();
                if (!links.containsKey(attr) || !row.has(attr)) continue;
                String col = links.get((Object)attr).col;
                MetaData cmd = this.metaDataService.getMetaMapItemByKey(col);
                String cEntityName = md.getEntityName();
                if (row.isNull(attr)) {
                    if (!col.equals(attr)) continue;
                    this.delete(cmd.getTableName(), row.get(idName));
                    continue;
                }
                this.doSave(row, idValue, attr, cmd, cEntityName, dataSourceName);
            }
            result.add((Serializable)idValue);
        });
        return result;
    }

    private void doSave(JSONObject row, Object idValue, String attr, MetaData cmd, String pEntityName, String dataSourceName) {
        Object obj = row.get(attr);
        if (obj instanceof JSONArray) {
            JSONArray rows = row.getJSONArray(attr);
            for (int i = 0; i < rows.length(); ++i) {
                this.partialSave(rows.getJSONObject(i), cmd, idValue, pEntityName, dataSourceName);
            }
        } else {
            this.partialSave((JSONObject)obj, cmd, idValue, pEntityName, dataSourceName);
        }
    }

    private boolean hasRow(String tableName, String idColName, Object idValue, ColumnTypeEnum idType, String dataSourceName) {
        return !this.sqlAction.query("EntityService@hasRow", "select 1 from " + tableName + " where " + idColName + "=" + this.normalizeValue(idValue, idType), new QueryParams.Builder().dataSource(dataSourceName).build()).isEmpty();
    }

    private int doUpdate(JSONObject row, MetaData md, Object pIdValue, String pEntityName, Object idValue, ColumnTypeEnum idType, Map<String, Pair> columns, String dataSourceName) {
        Map<String, Pair> associations;
        if (row.keySet().size() == 1) {
            return -1;
        }
        Object verValue = null;
        String verName = md.getVerName();
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        StringBuilder sb = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = md.getAssociations()) != null && associations.containsKey(pEntityName)) {
            Pair pair = associations.get(pEntityName);
            foreignkey = pair.col;
            sb.append(" ").append(foreignkey).append("=").append(this.normalizeValue(pIdValue, pair.type)).append(", ");
        }
        if (verName != null) {
            ColumnTypeEnum verType = md.getVerType();
            sb.append(" ").append(verName).append("=").append(this.normalizeVer(verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sb.append(" ").append(pair.col).append("=").append((String)(row.isNull(attr) ? "null, " : this.normalizeValue(row.get(attr), pair.type) + ", "));
        }
        Integer affectedRow = null;
        if (!sb.isEmpty()) {
            sb.delete(sb.length() - 2, sb.length());
            sb.insert(0, "UPDATE " + md.getTableName() + " SET");
            sb.append(" WHERE ").append(md.getIdColName()).append(" = ").append(this.normalizeValue(idValue, idType));
            if (md.getVerName() != null) {
                ColumnTypeEnum verType = md.getVerType();
                sb.append(" AND ").append(md.getVerColName()).append(" = ").append(this.normalizeValue(verValue, verType));
            }
            affectedRow = this.sqlAction.exec("EntityService@doUpdate", sb.toString(), dataSourceName);
        }
        if (md.hasSubclasses()) {
            String sentity;
            SubClasses p;
            Map<String, SubClasses> subclasses = md.getSubclasses();
            Iterator<String> iterator = subclasses.keySet().iterator();
            while (iterator.hasNext() && !row.isNull((p = subclasses.get(sentity = iterator.next())).col())) {
                String dv = row.getString(p.col());
                String pTypeStr = p.type();
                if (!pTypeStr.equals(dv) && !pTypeStr.contains(dv + ",") && !pTypeStr.contains("," + dv)) continue;
                StringBuilder buf = new StringBuilder();
                MetaData smd = this.metaDataService.getMetaMapItemByKey(sentity);
                String keyAttr = smd.getIdColName();
                Map<String, Pair> attrs = smd.getColumns();
                for (String attr : attrs.keySet()) {
                    if (attr.equals(keyAttr) || !row.has(attr)) continue;
                    Pair a = attrs.get(attr);
                    buf.append(a.col).append("=").append(this.normalizeValue(row.isNull(attr) ? null : row.get(attr), a.type)).append(", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.insert(0, "UPDATE " + smd.getTableName() + " SET ");
                buf.append(" WHERE ").append(smd.getIdColName()).append(" = ").append(this.normalizeValue(idValue, idType));
                this.sqlAction.exec("EntityService@doUpdate-child", buf.toString(), dataSourceName);
                if (affectedRow == null) {
                    affectedRow = 1;
                }
                Map<String, Pair> links = smd.getLinks();
                Map<String, Pair> pLinks = md.getLinks();
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    String col = links.get((Object)attr).col;
                    MetaData cmd = this.metaDataService.getMetaMapItemByKey(col);
                    String cEntityName = smd.getEntityName();
                    if (row.isNull(attr)) {
                        if (!col.equals(attr)) continue;
                        this.delete(cmd.getTableName(), idValue);
                        continue;
                    }
                    this.doSave(row, idValue, attr, cmd, cEntityName, dataSourceName);
                }
                break block1;
            }
        }
        this.handleInverses(row, md, dataSourceName);
        return affectedRow == null ? 0 : affectedRow;
    }

    private void handleInverses(JSONObject row, MetaData md, String dataSourceName) {
        Map<String, String> inverses = md.getInverses();
        for (String inverse : inverses.keySet()) {
            Object arow;
            if (row.isNull(inverse) || !((arow = row.get(inverse)) instanceof JSONObject)) continue;
            MetaData amd = this.metaDataService.getMetaMapItemByKey(inverses.get(inverse));
            this.partialSave((JSONObject)arow, amd, null, null, dataSourceName);
        }
    }

    private int doInsert(JSONObject row, MetaData md, Object pIdValue, String pEntityName, String idName, ColumnTypeEnum idType, Map<String, Pair> columns, String dataSourceName) {
        int affectedRows;
        Map<String, Pair> associations;
        Object verValue = null;
        String verName = md.getVerName();
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        String idColName = md.getIdColName();
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = md.getAssociations()) != null) {
            for (String ass : associations.keySet()) {
                if (!ass.equals(pEntityName) && !this.hasParent(ass, pEntityName)) continue;
                Pair pair = associations.get(ass);
                foreignkey = pair.col;
                if (sbCols.indexOf(foreignkey + ",") != -1) continue;
                sbCols.append(foreignkey).append(", ");
                sbValues.append(this.normalizeValue(pIdValue, pair.type)).append(", ");
            }
        }
        if (verName != null) {
            sbCols.append(verName).append(", ");
            ColumnTypeEnum verType = md.getVerType();
            sbValues.append(this.normalizeVer(verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sbCols.append(pair.col).append(", ");
            sbValues.append((String)(row.isNull(attr) ? "null, " : this.normalizeValue(row.get(attr), pair.type) + ", "));
        }
        IDTypeEnum idTypeEnum = md.getIdGenerator();
        switch (idTypeEnum) {
            case ID_GUID: {
                sbCols.append(idColName).append(", ");
                String guid = UUID.randomUUID().toString().replace("-", "");
                sbValues.append("'").append(guid).append("', ");
                row.put(idName, (Object)guid);
                break;
            }
            case ID_SEQ: {
                sbCols.append(idColName).append(", ");
                String aid = this.getLastSeqId(md.getSequence(), dataSourceName);
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
            case ID_ASSIGNED: {
                sbCols.append(idColName).append(", ");
                sbValues.append(this.normalizeValue(row.get(idName), idType)).append(", ");
                row.put(idName, row.get(idName));
                break;
            }
            case ID_FOREIGNER: {
                sbCols.append(idColName).append(", ");
                String aid = this.normalizeValue(pIdValue, idType);
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
        }
        if (md.hasInverses()) {
            Map<String, String> inverses = md.getInverses();
            Map<String, Pair> inversesid = md.getInverseid();
            for (String inverse : inverses.keySet()) {
                Pair pair;
                if (row.isNull(inverse)) continue;
                Object arow = row.get(inverse);
                if (!(arow instanceof JSONObject)) {
                    pair = inversesid.get(inverse);
                    sbCols.append(pair.col).append(", ");
                    sbValues.append(this.normalizeValue(arow, pair.type)).append(", ");
                    continue;
                }
                JSONObject json = (JSONObject)arow;
                sbCols.append(inverse).append(", ");
                pair = inversesid.get(inverse);
                arow = json.get(pair.col);
                sbValues.append(this.normalizeValue(arow, pair.type)).append(", ");
            }
        }
        if (sbCols.isEmpty()) {
            throw new ServiceException("\u4f20\u5165\u7684\u5b9e\u4f53\u5185\u5bb9\u65e0\u6548\uff1a" + String.valueOf(row) + "\uff0c\u76f8\u5173\u5b9e\u4f53\u540d\uff1a" + md.getTableName(), Integer.valueOf(400));
        }
        sbCols.delete(sbCols.length() - 2, sbCols.length());
        sbCols.insert(0, "INSERT INTO " + md.getTableName() + " (");
        sbValues.delete(sbValues.length() - 2, sbValues.length());
        sbCols.append(") VALUES (");
        sbCols.append((CharSequence)sbValues);
        sbCols.append(")");
        if (idTypeEnum == IDTypeEnum.ID_AUTO) {
            Tuple tuple;
            try {
                tuple = this.rawJdbcUpdate(sbCols.toString(), dataSourceName);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            row.put(idName, (Object)tuple.get(1).toString());
            affectedRows = (Integer)tuple.get(0);
        } else {
            affectedRows = this.sqlAction.exec("EntityService@doInsert", sbCols.toString(), dataSourceName);
        }
        if (md.hasSubclasses()) {
            String sentity;
            SubClasses p;
            Map<String, SubClasses> subclasses = md.getSubclasses();
            Iterator<String> iterator = subclasses.keySet().iterator();
            while (iterator.hasNext() && !row.isNull((p = subclasses.get(sentity = iterator.next())).col())) {
                Map<String, Pair> associations2;
                String dv = row.getString(p.col());
                String pTypeStr = p.type();
                if (!pTypeStr.equals(dv) && !pTypeStr.contains(dv + ",") && !pTypeStr.contains("," + dv)) continue;
                StringBuilder fields = new StringBuilder();
                StringBuilder vals = new StringBuilder();
                MetaData smd = this.metaDataService.getMetaMapItemByKey(sentity);
                String keyCol = smd.getIdColName();
                fields.append(keyCol).append(", ");
                vals.append(this.normalizeValue(row.get(idName), idType)).append(", ");
                Map<String, Pair> attrs = smd.getColumns();
                for (String string : attrs.keySet()) {
                    if (!row.has(string)) continue;
                    Pair a = attrs.get(string);
                    if (a.col.equals(foreignkey)) continue;
                    fields.append(a.col).append(", ");
                    vals.append(this.normalizeValue(row.isNull(string) ? null : row.get(string), a.type)).append(", ");
                }
                if (smd.hasInverseIds()) {
                    Map<String, Pair> lookup = smd.getInverseid();
                    for (String property : lookup.keySet()) {
                        if (!row.has(property) || row.isNull(property)) continue;
                        Object obj = row.get(property);
                        Pair pair = lookup.get(property);
                        if (obj instanceof JSONObject) {
                            JSONObject record = (JSONObject)obj;
                            if (!record.has(pair.col) || record.isNull(pair.col)) continue;
                            fields.append(pair.col).append(", ");
                            vals.append(this.normalizeValue(record.get(pair.col), pair.type)).append(", ");
                            continue;
                        }
                        fields.append(pair.col).append(", ");
                        vals.append(this.normalizeValue(row.get(property), pair.type)).append(", ");
                    }
                }
                if ((associations2 = md.getAssociations()) != null) {
                    for (String ass : associations2.keySet()) {
                        Pair pair = associations2.get(ass);
                        foreignkey = pair.col;
                        if (!attrs.containsKey(foreignkey) || pIdValue == null || fields.indexOf(foreignkey + ", ") != -1) continue;
                        fields.append(foreignkey).append(", ");
                        vals.append(this.normalizeValue(pIdValue, pair.type)).append(", ");
                    }
                }
                fields.delete(fields.length() - 2, fields.length());
                vals.delete(vals.length() - 2, vals.length());
                fields.insert(0, "INSERT INTO " + smd.getTableName() + " (");
                fields.append(") VALUES (");
                fields.append((CharSequence)vals);
                fields.append(")");
                this.sqlAction.exec("EntityService@doInsert-child", fields.toString(), dataSourceName);
                Map<String, Pair> map = smd.getLinks();
                Map<String, Pair> pLinks = md.getLinks();
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !map.containsKey(attr) || !row.has(attr)) continue;
                    String col = map.get((Object)attr).col;
                    MetaData cmd = this.metaDataService.getMetaMapItemByKey(col);
                    String cEntityName = smd.getEntityName();
                    if (row.isNull(attr)) {
                        if (!col.equals(attr)) continue;
                        this.delete(cmd.getTableName(), row.get(idName));
                        continue;
                    }
                    this.doSave(row, row.get(idName), attr, cmd, cEntityName, dataSourceName);
                }
                break block11;
            }
        }
        this.handleInverses(row, md, dataSourceName);
        return affectedRows;
    }

    private boolean hasParent(String entity, String pEntityName) {
        if (entity == null || pEntityName == null) {
            return false;
        }
        Map<String, String> entityLiftMap = MetaDataService.getEntityLiftMap();
        HashSet<String> visitedEntities = new HashSet<String>();
        while (entityLiftMap.containsKey(entity)) {
            if (!visitedEntities.add(entity)) {
                return false;
            }
            String pEntity = entityLiftMap.get(entity);
            if (pEntity.equals(pEntityName)) {
                return true;
            }
            entity = pEntity;
        }
        return false;
    }

    private Tuple rawJdbcUpdate(String sql, String dataSourceName) {
        AtomicReference tuple = new AtomicReference();
        return (Tuple)DynamicDataSource.withDataSource((String)dataSourceName, () -> {
            this.sessionPool.getSession().doWork(connection -> {
                LOGGER.info("\u6267\u884c\u539f\u751fSQL\uff1a{\n{}\n}", (Object)sql);
                PreparedStatement statement = connection.prepareStatement(sql, 1);
                int affectedRows = statement.executeUpdate();
                if (affectedRows != 0) {
                    ResultSet rs = statement.getGeneratedKeys();
                    if (rs.next()) {
                        String idValue = String.valueOf(rs.getLong(1));
                        tuple.set(new Tuple(new Object[]{affectedRows, idValue}));
                    } else {
                        throw new RuntimeException("\u5f97\u5230\u63d2\u5165\u8bb0\u5f55id\u5931\u8d25\u3002");
                    }
                }
            });
            return (Tuple)tuple.get();
        });
    }

    private String getLastSeqId(String seq, String dataSourceName) {
        DbType dbType = DynamicDataSource.getDbType();
        String sql = dbType == DbType.postgresql ? "SELECT nextval('" + seq + "') newid" : "select " + seq + ".nextval newid from dual";
        return this.sqlAction.query("EntityService@getLastSeqId", sql, new QueryParams.Builder().dataSource(dataSourceName).build()).getJSONObject(0).get("newid").toString();
    }

    private String normalizeVer(Object verValue, ColumnTypeEnum verType) {
        DbType dbType = DynamicDataSource.getDbType();
        if (verType == ColumnTypeEnum.COL_TIME) {
            if (dbType == DbType.oracle) {
                return "current_timestamp";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + sdf.format(new Date()) + "'";
        }
        if (verValue == null) {
            return "1";
        }
        return String.valueOf(Integer.parseInt(String.valueOf(verValue)) + 1);
    }

    private String normalizeValue(Object value, ColumnTypeEnum valType) {
        if (value == null) {
            return "null";
        }
        DbType dbType = DynamicDataSource.getDbType();
        switch (valType) {
            case COL_STRING: {
                return "'" + String.valueOf(value) + "'";
            }
            case COL_INTEGER: 
            case COL_DOUBLE: 
            case COL_LONG: 
            case COL_DECIMAL: {
                if ("".equals(value)) {
                    return "null";
                }
                return String.valueOf(value);
            }
            case COL_BOOLEAN: {
                if (dbType == DbType.oracle) {
                    return "'" + ((Boolean)value != false ? "Y" : "N") + "'";
                }
                if (value instanceof Byte) {
                    return value.toString();
                }
                if (value instanceof Integer) {
                    return value.toString();
                }
                return (Boolean)value != false ? "1" : "0";
            }
            case COL_DATE: {
                if (dbType == DbType.oracle) {
                    return "TO_DATE(SUBSTR('" + String.valueOf(value) + "', 1, 10), 'YYYY-MM-DD')";
                }
                return "'" + String.valueOf(value) + "'";
            }
            case COL_TIME: {
                if (dbType == DbType.oracle) {
                    return "TO_TIMESTAMP('" + String.valueOf(value) + "', 'YYYY-MM-DD HH24:MI:SS')";
                }
                return "'" + String.valueOf(value) + "'";
            }
            case COL_CLOB: {
                if (dbType == DbType.oracle) {
                    String[] parts;
                    StringBuilder sql = new StringBuilder();
                    for (String part : parts = StrUtil.split((CharSequence)value.toString(), (int)2000)) {
                        sql.append("TO_CLOB('").append(part).append("')||");
                    }
                    int length = sql.length();
                    sql.delete(length - 2, length);
                    return sql.toString();
                }
                return "'" + String.valueOf(value) + "'";
            }
        }
        throw new ServiceException("\u4f20\u9012\u6570\u636e\u7c7b\u578b\u51fa\u9519", Integer.valueOf(506));
    }

    public void sqlserverBulkInsert(String entityName, JSONArray rowArray, String dataSourceName) {
        MetaData map = this.metaDataService.getMetaMapItemByKey(entityName);
        String tableName = map.getTableName();
        String idColName = map.getIdColName();
        ColumnTypeEnum typeEnum = map.getIdType();
        Map<String, Pair> normalColumns = map.getColumns();
        HashMap<String, Pair> allColumns = new HashMap<String, Pair>(normalColumns.size() + 1);
        allColumns.put(idColName, new Pair(idColName, typeEnum));
        allColumns.putAll(map.getColumns());
        DynamicDataSource.withDataSource((String)dataSourceName, () -> this.sessionPool.getSession().doWork(connection -> {
            PreparedStatement statement = connection.prepareStatement("SELECT * FROM " + tableName + " WHERE 1 = 0");
            try (ResultSet rs = statement.executeQuery();
                 CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();){
                crs.populate(rs);
                for (Object o : rowArray) {
                    JSONObject params = (JSONObject)o;
                    crs.moveToInsertRow();
                    for (Map.Entry entry : allColumns.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = params.opt(key);
                        Pair pair = (Pair)entry.getValue();
                        ColumnTypeEnum columnTypeEnum = pair.type;
                        switch (columnTypeEnum) {
                            case COL_STRING: {
                                crs.updateString(key, value == null ? "" : value.toString());
                                break;
                            }
                            case COL_INTEGER: {
                                crs.updateInt(key, Integer.parseInt(value == null ? "0" : value.toString()));
                                break;
                            }
                            case COL_LONG: {
                                crs.updateLong(key, Long.parseLong(value == null ? "0" : value.toString()));
                                break;
                            }
                            case COL_DOUBLE: {
                                crs.updateDouble(key, Double.parseDouble(value == null ? "0" : value.toString()));
                                break;
                            }
                            case COL_TIME: {
                                crs.updateTimestamp(key, new Timestamp((value == null ? DateTime.now() : DateUtil.parse((CharSequence)value.toString())).toSqlDate().getTime()));
                                break;
                            }
                            case COL_DATE: {
                                crs.updateDate(key, (value == null ? DateTime.now() : DateUtil.parse((CharSequence)value.toString())).toSqlDate());
                                break;
                            }
                            case COL_BOOLEAN: {
                                crs.updateBoolean(key, Boolean.parseBoolean(value == null ? "false" : value.toString()));
                                break;
                            }
                            case COL_DECIMAL: {
                                crs.updateBigDecimal(key, new BigDecimal(value == null ? "0" : value.toString()));
                            }
                        }
                    }
                    crs.insertRow();
                    crs.moveToCurrentRow();
                }
                SQLServerBulkCopyOptions copyOptions = new SQLServerBulkCopyOptions();
                copyOptions.setKeepIdentity(true);
                copyOptions.setBatchSize(8000);
                copyOptions.setUseInternalTransaction(true);
                AfDataSourceConfig dataSource = DynamicDataSource.getWrapper().getConfig();
                Object jdbcUrl = dataSource.getUrl();
                if (!((String)jdbcUrl).endsWith(";")) {
                    jdbcUrl = (String)jdbcUrl + ";";
                }
                jdbcUrl = (String)jdbcUrl + "username=" + dataSource.getUsername() + ";password=" + dataSource.getPassword() + ";";
                try (SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy((String)jdbcUrl);){
                    bulkCopy.setBulkCopyOptions(copyOptions);
                    bulkCopy.setDestinationTableName(tableName);
                    bulkCopy.writeToServer((RowSet)crs);
                }
            }
        }));
    }

    public void sqlserverBulkInsert(String entityName, JSONArray rowArray) {
        this.sqlserverBulkInsert(entityName, rowArray, null);
    }

    public JSONObject remoteDelete(String serviceName, String entityName, Object id) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.deleteById(entityName, String.valueOf(id), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteDeleteAllByIds(String serviceName, String entityName, JSONArray ids) {
        JSONObject params = new JSONObject();
        params.put("ids", (Object)ids);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.deleteAllByIds(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAllByIds(String serviceName, String columns, String entityName, JSONArray ids) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        params.put("ids", (Object)ids);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.findAllByIds(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAllByIds(String serviceName, String entityName, JSONArray ids) {
        return this.remoteFindAllByIds(serviceName, null, entityName, ids);
    }

    public JSONObject remoteGetCount(String serviceName, String entityName) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.getCount(entityName, "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAll(String serviceName, String columns, String entityName) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.findAll(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAll(String serviceName, String entityName) {
        return this.remoteFindAll(serviceName, "*", entityName);
    }

    public JSONObject remoteGetById(String serviceName, String columns, String entityName, Object id) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.getById(entityName, String.valueOf(id), params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteGetById(String serviceName, String entityName, Object id) {
        return this.remoteGetById(serviceName, "*", entityName, String.valueOf(id));
    }

    public JSONObject remoteSaveByKey(String serviceName, String entityName, JSONObject row, JSONArray keyArray, Boolean isCover) {
        JSONObject params = new JSONObject();
        params.put("entity", (Object)row);
        params.put("keyArray", (Object)keyArray);
        params.put("isCover", (Object)isCover);
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.saveByKey(entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteSaveByKey(String serviceName, String entityName, JSONObject row, JSONArray keyArray) {
        return this.remoteSaveByKey(serviceName, entityName, row, keyArray, true);
    }

    public JSONObject remotePartialSave(String serviceName, String entityName, JSONObject row) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.save(entityName, row.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remotePartialSave(String serviceName, String entityName, JSONArray rowArray) {
        RemoteEntityService remoteEntityService = (RemoteEntityService)this.dynamicFeignClientFactory.getFeignClient(RemoteEntityService.class, serviceName);
        R result = remoteEntityService.saveBatch(entityName, rowArray.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject partialSaveWithSharding(String entityName, JSONObject row, String shardingStrategy, String dataSourceName) {
        return this.partialSaveWithSharding(entityName, new JSONArray().put((Object)row), shardingStrategy, dataSourceName).getJSONObject(0);
    }

    public JSONObject partialSaveWithSharding(String entityName, JSONObject row, String shardingStrategy) {
        return this.partialSaveWithSharding(entityName, row, shardingStrategy, null);
    }

    public JSONArray partialSaveWithSharding(String entityName, JSONArray rowArray, String shardingStrategy, String dataSourceName) {
        JSONArray result;
        DbType dbType = DynamicDataSource.getDbType();
        if (dbType == DbType.clickhouse) {
            result = new JSONArray();
            this.clickhouseService.save(entityName, rowArray);
        } else {
            MetaData md;
            if (MetaDataService.getEntityLiftMap().containsKey(entityName)) {
                String pEntityName = MetaDataService.getEntityLiftValueByKey(entityName);
                md = this.metaDataService.getMetaMapItemByKey(pEntityName).copy();
                this.metaDataService.enchanceMetaData(md, entityName);
            } else {
                md = this.metaDataService.getMetaMapItemByKey(entityName);
            }
            if (StrUtil.isNotBlank((CharSequence)shardingStrategy)) {
                String originalTableName = md.getTableName();
                String shardedTableName = this.getTableNameWithSharding(originalTableName, shardingStrategy);
                md.setTableName(shardedTableName);
                LOGGER.info("\u4f7f\u7528\u5206\u8868\u7b56\u7565 [{}] \u5c06\u8868\u540d [{}] \u8f6c\u6362\u4e3a [{}]", new Object[]{shardingStrategy, originalTableName, shardedTableName});
            }
            List<Serializable> aid = this.partialSave(rowArray, md, null, null, dataSourceName);
            result = new JSONArray(aid.size());
            aid.forEach(item -> {
                JSONObject obj = new JSONObject();
                obj.put(md.getIdColName(), (Object)item.toString());
                result.put((Object)obj);
            });
        }
        return result;
    }

    public JSONArray partialSaveWithSharding(String entityName, JSONArray rowArray, String shardingStrategy) {
        return this.partialSaveWithSharding(entityName, rowArray, shardingStrategy, null);
    }

    public Object NULL() {
        return JSONObject.NULL;
    }
}

