/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.dynamic;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import com.af.v4.system.common.jpa.dynamic.DynamicSessionFactory;
import com.af.v4.system.common.jpa.utils.SessionFactoryBeanBuilder;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.metamodel.Metamodel;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.graph.RootGraph;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.relational.SchemaManager;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

public class DynamicSessionFactoryImpl
implements DynamicSessionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSessionFactoryImpl.class);
    private static final long serialVersionUID = 5384069312247414885L;
    private static final Integer DEFAULT_WAIT_TIME = 5000;
    private final Map<String, LocalSessionFactoryBean> localSessionFactoryBeans;
    private final Object lock = new Object();

    public DynamicSessionFactoryImpl() {
        this.localSessionFactoryBeans = new ConcurrentHashMap<String, LocalSessionFactoryBean>(DynamicDataSource.getDataSourceMap().size());
    }

    @Override
    public SessionFactory getHibernateSessionFactory() {
        return this.getLocalSessionFactoryBean().getObject();
    }

    @Override
    public Configuration getConfiguration() {
        return this.getLocalSessionFactoryBean().getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalSessionFactoryBean getLocalSessionFactoryBean(String dataSourceName) {
        LocalSessionFactoryBean sessionFactoryBean = this.localSessionFactoryBeans.get(dataSourceName);
        if (sessionFactoryBean != null) {
            return sessionFactoryBean;
        }
        Object object = this.lock;
        synchronized (object) {
            sessionFactoryBean = this.localSessionFactoryBeans.get(dataSourceName);
            if (sessionFactoryBean != null) {
                return sessionFactoryBean;
            }
            AfDataSourceWrapper afDataSourceWrapper = (AfDataSourceWrapper)DynamicDataSource.getDataSourceMap().get(dataSourceName);
            if (afDataSourceWrapper != null) {
                try {
                    LocalSessionFactoryBean bean = ((SessionFactoryBeanBuilder)SpringUtils.getBean(SessionFactoryBeanBuilder.class)).buildSessionFactory(dataSourceName, afDataSourceWrapper);
                    this.localSessionFactoryBeans.put(dataSourceName, bean);
                    return bean;
                }
                catch (Exception e) {
                    if (e instanceof BeanCreationException) {
                        throw new ServiceException("\u6570\u636e\u6e90[" + dataSourceName + "]\u8fde\u63a5\u5931\u8d25\u2014\u2014\u2014\u2014" + e.getMessage(), Integer.valueOf(500));
                    }
                    if (dataSourceName.equals("master")) {
                        LOGGER.error("\u6570\u636e\u6e90[{}]\u8fde\u63a5\u5931\u8d25\uff0c{}\u6beb\u79d2\u540e\u91cd\u8bd5...", new Object[]{"master", DEFAULT_WAIT_TIME, e});
                        try {
                            Thread.sleep(DEFAULT_WAIT_TIME.intValue());
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        return this.getLocalSessionFactoryBean("master");
                    }
                    throw new ServiceException("\u6570\u636e\u6e90[" + dataSourceName + "]\u8fde\u63a5\u5931\u8d25\u2014\u2014\u2014\u2014" + e.getMessage(), Integer.valueOf(500));
                }
            }
            if (dataSourceName.equals("master")) {
                throw new ServiceException("\u672a\u6307\u5b9a\u9ed8\u8ba4\u6570\u636e\u6e90 : [" + dataSourceName + "]");
            }
            return this.getLocalSessionFactoryBean("master");
        }
    }

    @Override
    public LocalSessionFactoryBean getLocalSessionFactoryBean() {
        return this.getLocalSessionFactoryBean(DynamicDataSource.getDataSource());
    }

    @Override
    public Metadata getMetadata() {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.getConfiguration().getStandardServiceRegistryBuilder().build());
        return metadataSources.buildMetadata();
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.getHibernateSessionFactory().getSessionFactoryOptions();
    }

    public SessionBuilder withOptions() {
        return this.getHibernateSessionFactory().withOptions();
    }

    public Session openSession() throws HibernateException {
        return this.getHibernateSessionFactory().openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getHibernateSessionFactory().getCurrentSession();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.getHibernateSessionFactory().withStatelessOptions();
    }

    public StatelessSession openStatelessSession() {
        return this.getHibernateSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getHibernateSessionFactory().openStatelessSession(connection);
    }

    public Statistics getStatistics() {
        return this.getHibernateSessionFactory().getStatistics();
    }

    public SchemaManager getSchemaManager() {
        return this.getHibernateSessionFactory().getSchemaManager();
    }

    public void close() throws HibernateException {
        SessionFactory sessionFactory = this.getHibernateSessionFactory();
        if (sessionFactory != null) {
            sessionFactory.close();
        }
    }

    public Map<String, Object> getProperties() {
        return this.getHibernateSessionFactory().getProperties();
    }

    public boolean isClosed() {
        return this.getHibernateSessionFactory().isClosed();
    }

    public Cache getCache() {
        return this.getHibernateSessionFactory().getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getHibernateSessionFactory().getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.getHibernateSessionFactory().addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getHibernateSessionFactory().unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.getHibernateSessionFactory().addNamedEntityGraph(graphName, entityGraph);
    }

    public Set<String> getDefinedFilterNames() {
        return this.getHibernateSessionFactory().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getHibernateSessionFactory().getFilterDefinition(filterName);
    }

    public Set<String> getDefinedFetchProfileNames() {
        return this.getHibernateSessionFactory().getDefinedFetchProfileNames();
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.getHibernateSessionFactory().containsFetchProfileDefinition(name);
    }

    public Reference getReference() throws NamingException {
        return this.getHibernateSessionFactory().getReference();
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.getHibernateSessionFactory().findEntityGraphsByType(entityClass);
    }

    public RootGraph<?> findEntityGraphByName(String name) {
        return this.getHibernateSessionFactory().findEntityGraphByName(name);
    }

    public EntityManager createEntityManager() {
        return this.getHibernateSessionFactory().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getHibernateSessionFactory().createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.getHibernateSessionFactory().createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.getHibernateSessionFactory().createEntityManager(synchronizationType, map);
    }

    public HibernateCriteriaBuilder getCriteriaBuilder() {
        return this.getHibernateSessionFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getHibernateSessionFactory().getMetamodel();
    }

    public boolean isOpen() {
        return this.getHibernateSessionFactory().isOpen();
    }
}

