package com.af.v4.system.common.jpa.types;

import com.af.v4.system.common.jpa.enums.ColumnTypeEnum;
import com.af.v4.system.common.jpa.enums.IDTypeEnum;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 实体元数据
 */
public class MetaData implements Serializable {
    /**
     * 实体名称
     */
    private String entityName;
    /**
     * 表名
     */
    private String tableName;
    /**
     * 主键属性名称
     */
    private String idName;
    /**
     * 主键列名
     */
    private String idColName;
    /**
     * 主键类型
     */
    private ColumnTypeEnum idType;
    /**
     * 主键生成策略
     */
    private IDTypeEnum idGenerator;
    /**
     * 序列名
     */
    private String sequence;
    /**
     * 版本属性名称
     */
    private String verName;
    /**
     * 版本列名
     */
    private String verColName;
    /**
     * 版本类型
     */
    private ColumnTypeEnum verType;
    /**
     * 属性列
     */
    private Map<String, Pair> columns;
    /**
     * 一对一，一对多关系映射
     */
    private Map<String, Pair> links;
    /**
     * 反向关系映射
     */
    private Map<String, String> inverses;
    /**
     * 反向ID映射
     */
    private Map<String, Pair> inverseid;
    /**
     * 关联属性
     */
    private Map<String, Pair> associations;
    /**
     * 一对一映射（手机端用）
     */
    private Map<String, Pair> onetoone;
    /**
     * 一对多映射（手机端用）
     */
    private Map<String, Pair> onetomany;
    /**
     * 子类映射
     */
    private Map<String, SubClasses> subclasses;

    public MetaData() {
        this.onetoone = new HashMap<>(0);
        this.onetomany = new HashMap<>(0);
    }

    public String getEntityName() {
        return entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIdName() {
        return idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public String getIdColName() {
        return idColName;
    }

    public void setIdColName(String idColName) {
        this.idColName = idColName;
    }

    public ColumnTypeEnum getIdType() {
        return idType;
    }

    public void setIdType(ColumnTypeEnum idType) {
        this.idType = idType;
    }

    public IDTypeEnum getIdGenerator() {
        return idGenerator;
    }

    public void setIdGenerator(IDTypeEnum idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getSequence() {
        return sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getVerName() {
        return verName;
    }

    public void setVerName(String verName) {
        this.verName = verName;
    }

    public String getVerColName() {
        return verColName;
    }

    public void setVerColName(String verColName) {
        this.verColName = verColName;
    }

    public ColumnTypeEnum getVerType() {
        return verType;
    }

    public void setVerType(ColumnTypeEnum verType) {
        this.verType = verType;
    }

    public Map<String, Pair> getColumns() {
        return columns;
    }

    public void setColumns(Map<String, Pair> columns) {
        this.columns = columns;
    }

    public Map<String, Pair> getLinks() {
        return links;
    }

    public void setLinks(Map<String, Pair> links) {
        this.links = links;
        this.onetomany = links;
    }

    public Map<String, String> getInverses() {
        return inverses;
    }

    public void setInverses(Map<String, String> inverses) {
        this.inverses = inverses;
    }

    public boolean hasInverses() {
        return inverses != null;
    }

    public Map<String, Pair> getInverseid() {
        return inverseid;
    }

    public void setInverseid(Map<String, Pair> inverseid) {
        this.inverseid = inverseid;
    }

    public boolean hasInverseIds() {
        return inverseid != null;
    }

    public Map<String, Pair> getAssociations() {
        return associations;
    }

    public void setAssociations(Map<String, Pair> associations) {
        this.associations = associations;
    }

    public boolean hasAssociations() {
        return associations != null;
    }

    public Map<String, SubClasses> getSubclasses() {
        return subclasses;
    }

    public void setSubclasses(Map<String, SubClasses> subclasses) {
        this.subclasses = subclasses;
    }

    public boolean hasSubclasses() {
        return subclasses != null;
    }

    public Map<String, Pair> getOnetoone() {
        return onetoone;
    }

    public void setOnetoone(Map<String, Pair> onetoone) {
        this.onetoone = onetoone;
    }

    public Map<String, Pair> getOnetomany() {
        return onetomany;
    }

    public void setOnetomany(Map<String, Pair> onetomany) {
        this.onetomany = onetomany;
    }

    public MetaData copy() {
        MetaData result = new MetaData();

        // 复制基本字段
        result.entityName = this.entityName;
        result.tableName = this.tableName;
        result.idName = this.idName;
        result.idColName = this.idColName;
        result.idType = this.idType;
        result.idGenerator = this.idGenerator;
        result.sequence = this.sequence;
        result.verName = this.verName;

        // 复制集合字段，进行深拷贝
        if (this.columns != null) {
            result.columns = new LinkedHashMap<>(this.columns.size());
            for (Map.Entry<String, Pair> entry : this.columns.entrySet()) {
                result.columns.put(entry.getKey(), entry.getValue().copy());
            }
        }

        if (this.links != null) {
            result.setLinks(new HashMap<>(this.links));
        }

        if (this.inverses != null) {
            result.inverses = new HashMap<>(this.inverses);
        }

        if (this.inverseid != null) {
            result.inverseid = new HashMap<>(this.inverseid.size());
            for (Map.Entry<String, Pair> entry : this.inverseid.entrySet()) {
                result.inverseid.put(entry.getKey(), entry.getValue().copy());
            }
        }

        if (this.associations != null) {
            result.associations = new HashMap<>(this.associations.size());
            for (Map.Entry<String, Pair> entry : this.associations.entrySet()) {
                result.associations.put(entry.getKey(), entry.getValue().copy());
            }
        }

        if (this.subclasses != null) {
            result.subclasses = new LinkedHashMap<>(this.subclasses.size());
            for (Map.Entry<String, SubClasses> entry : this.subclasses.entrySet()) {
                result.subclasses.put(entry.getKey(), entry.getValue().copy());
            }
        }

        return result;
    }
}
