package com.af.v4.system.common.jpa.dialect;

import com.af.v4.system.common.datasource.DynamicDataSource;
import org.hibernate.dialect.*;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;

import java.lang.reflect.InvocationTargetException;

/**
 * 自定义方言解析器
 */
public final class MyDialectResolver implements DialectResolver {

    @Override
    public Dialect resolveDialect(DialectResolutionInfo info) {
        for (Database database : Database.values()) {
            Dialect dialect = database.resolveDialect(info);
            if (dialect != null) {
                switch (dialect) {
                    case SQLServerDialect ignored -> {
                        if (dialect instanceof SQLServer2016Dialect) {
                            return new MySqlServerDialect2();
                        } else {
                            return new MySqlServerDialect();
                        }
                    }
                    case org.hibernate.dialect.MySQLDialect ignored -> {
                        if (dialect instanceof MySQL8Dialect) {
                            return new MySQLDialect2();
                        } else {
                            return new MySQLDialect();
                        }
                    }
                    case Oracle8iDialect ignored -> {
                        return new MyOracle10gDialect();
                    }
                    default -> {
                    }
                }
                return dialect;
            }
        }
        if (info.getDatabaseName().contains("ClickHouse")) {
            return new MyClickHouseDialect();
        } else if (info.getDatabaseName().contains("Dm")) {
            return new DmDialect();
        }
        try {
            return (Dialect) Class.forName(DynamicDataSource.getWrapper().getConfig().getDialect()).getConstructors()[0].newInstance();
        } catch (ClassNotFoundException | InvocationTargetException | InstantiationException |
                 IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}
