package com.af.v4.system.common.jpa.dialect;

import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.type.StandardBasicTypes;

import java.sql.Types;

/**
 * Oracle方言
 */
public class MyOracle10gDialect extends Oracle10gDialect {
    public MyOracle10gDialect() {
        super();
        //对应hibernate里面的数据类型，否则映射不正确！
        registerHibernateType(Types.NCHAR, StandardBasicTypes.CHARACTER.getName());
        registerHibernateType(Types.NCHAR, 1, StandardBasicTypes.CHARACTER.getName());
        registerHibernateType(Types.NCHAR, 255, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.NVARCHAR, StandardBasicTypes.STRING.getName());
        registerHibernateType(Types.LONGNVARCHAR, StandardBasicTypes.TEXT.getName());
        registerHibernateType(Types.NCLOB, StandardBasicTypes.CLOB.getName());
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from user_sequences";
    }
}
