package com.af.v4.system.common.jpa.dialect;

import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.type.StandardBasicTypes;

import java.sql.Types;

/**
 * Clickhouse方言
 */
public class MyClickHouseDialect extends MySQLDialect {

    public MyClickHouseDialect() {
        super();
        // 注册ClickHouse特定的函数和关键字
        registerColumnType(Types.BOOLEAN, "UInt8");
        registerColumnType(Types.TINYINT, "Int8");
        registerColumnType(Types.SMALLINT, "Int16");
        registerColumnType(Types.INTEGER, "Int32");
        registerColumnType(Types.BIGINT, "Int64");
        registerColumnType(Types.FLOAT, "Float32");
        registerColumnType(Types.DOUBLE, "Float64");
        registerColumnType(Types.DATE, "Date");
        registerColumnType(Types.TIMESTAMP, "DateTime");
        registerColumnType(Types.VARCHAR, "String");
        registerColumnType(Types.VARCHAR, 255, "String");

        registerFunction("year", new StandardSQLFunction("year", StandardBasicTypes.INTEGER));
        registerFunction("month", new StandardSQLFunction("month", StandardBasicTypes.INTEGER));
        registerFunction("day", new StandardSQLFunction("day", StandardBasicTypes.INTEGER));
    }

    @Override
    public String getTableTypeString() {
        return String.format(" %s = MergeTree", "ENGINE");
    }
}
