package com.af.v4.system.common.jpa.service;

import com.af.v4.system.common.jpa.action.SqlAction;
import org.json.JSONArray;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly = true, propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
public class SqlNewTranService {

    private final SqlAction sqlAction;

    public SqlNewTranService(SqlAction sqlAction) {
        this.sqlAction = sqlAction;
    }

    public JSONArray action(String name, String sql, Integer pageNo, Integer pageSize) {
        return sqlAction.query(name, sql, pageNo, pageSize);
    }

}
