/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.jpa.action.SqlAction;
import com.af.v4.system.common.jpa.service.SqlNewTranService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.resource.mapper.SqlMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlService.class);
    private final SqlMapper sqlMapper;
    private final SqlNewTranService sqlNewTranService;
    private final SqlAction sqlAction;
    private final ApplicationUtils applicationUtils;
    private LogicService logicService;

    public SqlService(SqlMapper sqlMapper, SqlNewTranService sqlNewTranService, SqlAction sqlAction, ApplicationUtils applicationUtils, LogicService logicService) {
        this.sqlMapper = sqlMapper;
        this.sqlNewTranService = sqlNewTranService;
        this.sqlAction = sqlAction;
        this.applicationUtils = applicationUtils;
        this.logicService = logicService;
    }

    public String getSQL(String name, JSONObject params) {
        return this.getSQLByFile(name, params);
    }

    public JSONObject queryTotal(String name, JSONObject params) {
        Object sums = null;
        if (params.has("sums")) {
            sums = params.get("sums");
        }
        String sql = this.getSQLByFile(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        JSONArray array = this.sqlAction.query(name, sql);
        return array.getJSONObject(0);
    }

    public JSONObject queryTotal(String name, String str) {
        return this.queryTotal(name, StringUtils.isEmpty((String)str) ? new JSONObject() : new JSONObject(str));
    }

    public JSONArray query(String name, JSONObject params, Integer pageNo, Integer pageSize) {
        String sql = this.getSQLByFile(name, params);
        return this.sqlAction.query(name, sql, pageNo, pageSize);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) {
        return this.query(name, params, 1, pageSize);
    }

    public JSONArray query(String name, JSONObject params) {
        return this.query(name, params, 1, 1000);
    }

    public JSONArray querySQL(String name, String sql) {
        return this.querySQL(name, sql, 1, 1000);
    }

    public JSONArray querySQL(String name, String sql, Integer pageSize) {
        return this.querySQL(name, sql, 1, pageSize);
    }

    public JSONArray querySQL(String name, String sql, Integer pageNo, Integer pageSize) {
        return this.sqlAction.query(name, sql, pageNo, pageSize);
    }

    public JSONArray querySQL(String name, String sql, Integer pageNo, Integer pageSize, Integer totals, String userId, String taskName) {
        if (pageNo == -1 && pageSize == -1) {
            return this.concurrentQuerySQL(name, sql, totals, userId, taskName);
        }
        return this.querySQL(name, sql, pageNo, pageSize);
    }

    public JSONArray concurrentQuerySQL(String name, String sql, Integer totals, String userId, String taskName) {
        List<Object> results;
        int pageSize = 10000;
        int pageCount = (int)Math.ceil((double)totals.intValue() / (double)pageSize);
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(4, pageCount));
        ArrayList<CompletableFuture<JSONArray>> futures = new ArrayList<CompletableFuture<JSONArray>>();
        AtomicInteger completedCount = new AtomicInteger(0);
        String dataSource = DynamicDataSource.getDataSource();
        for (int i = 0; i < pageCount; ++i) {
            int pageNo = i + 1;
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    JSONArray jSONArray = (JSONArray)DynamicDataSource.withDataSource((String)dataSource, () -> this.sqlNewTranService.action(name, sql, pageNo, pageSize));
                    return jSONArray;
                }
                finally {
                    int completed = completedCount.incrementAndGet();
                    double progress = (double)completed / (double)pageCount * 50.0;
                    progress = Math.ceil(progress * 100.0) / 100.0;
                    JSONObject progressJson = new JSONObject().put("taskName", (Object)taskName).put("progress", progress);
                    JSONObject message = new JSONObject().put("messageType", (Object)"task").put("progress", (Object)progressJson);
                    JSONArray userList = new JSONArray().put((Object)userId);
                    JSONObject param = new JSONObject().put("userList", (Object)userList).put("event", (Object)message.toString());
                    this.logicService.remoteRun("af-system", "sendMessage", String.valueOf(param));
                }
            }, executor));
        }
        try {
            CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            allOf.join();
            results = futures.stream().map(CompletableFuture::join).toList();
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5931\u8d25: ", (Throwable)e);
            results = new ArrayList();
        }
        JSONArray allData = new JSONArray();
        for (JSONArray result : results) {
            for (int i = 0; i < result.length(); ++i) {
                allData.put(result.get(i));
            }
        }
        executor.shutdown();
        return allData;
    }

    public Integer exec(String name, JSONObject params) {
        String sql = this.getSQLByFile(name, params);
        return this.execSQL(name, sql);
    }

    public Integer execSQL(String name, String sql) {
        return this.sqlAction.exec(name, sql);
    }

    private String getSQLByFile(String sqlName, JSONObject params) {
        SqlMapper.SqlResource resource = (SqlMapper.SqlResource)this.sqlMapper.getResource(sqlName);
        String source = resource.getSource();
        params.put("ENV", (Object)this.applicationUtils.getValues());
        params.put("RESOURCE", (Object)resource.getJsonParams());
        return Expression.run((String)source, (Map)params.toMap()).toString();
    }

    private String filterOutOrderBy(String source, Object sums) {
        int idx = source.toLowerCase().lastIndexOf("order by");
        if (idx == -1) {
            idx = source.length() - 1;
        }
        StringBuilder sql = new StringBuilder("select ");
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql.append("sum(").append(name).append(") ").append(name).append(", ");
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql.append("sum(").append(value).append(") ").append(name).append(", ");
                }
            }
        }
        if (idx != -1) {
            sql.append("count(*) n, 1 placeholder from ( ").append(source, 0, idx).append(") t_");
        }
        return sql.toString();
    }

    public String getDbTypeName() {
        return DynamicDataSource.getDbType().name();
    }

    public String resolveSQL(JSONObject sqlList) {
        String dbType = this.getDbTypeName();
        String sqlStr = sqlList.optString(dbType, null);
        if (sqlStr == null) {
            throw new ServiceException("\u672a\u627e\u5230\u7b26\u5408\u6570\u636e\u6e90[" + dbType + "]\u7684SQL");
        }
        return sqlStr;
    }
}

