package com.af.v4.system.common.jpa.utils;

public class PaginationUtils {

    /**
     * 根据总记录数返回分页大小
     *
     * @param totalRecords 总记录数
     * @return 页记录数
     */
    public static int determinePageSize(int totalRecords) {

        if (totalRecords < 10000) {
            return totalRecords; // 小数据量
        } else if (totalRecords <= 100000) {
            return 5000; // 中等数据量
        } else {
            return 10000; // 大数据量
        }
    }

    /**
     * 根据分页数量返回线程池大小
     *
     * @param pageCount 分页数量
     * @return 线程池大小
     */
    public static int determineThreadPoolSize(int pageCount) {

        int cpuCores = Runtime.getRuntime().availableProcessors();
        return Math.min(pageCount, cpuCores);
    }

}
