package com.af.v4.system.common.jpa.action;

import com.af.v4.system.common.core.constant.CodeNormsConstants;
import com.af.v4.system.common.jpa.utils.SQLRuntimeSupport;
import org.hibernate.EmptyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 监控拦截器
 */
@Component
public class MonitorInterceptor extends EmptyInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorInterceptor.class);

    @Override
    public String onPrepareStatement(String sql) {
        boolean disableLogPrint = SQLRuntimeSupport.getDisableLogPrintValue();
        if (!disableLogPrint) {
            LOGGER.info(CodeNormsConstants.DEBUG_PREFIX + "执行原生SQL：{\n{}\n}", sql);
        }
        return super.onPrepareStatement(sql);
    }
}
