package com.af.v4.system.common.jpa.utils;

import java.util.Objects;

/**
 * SQL运行时支持
 */
public class SQLRuntimeSupport {
    /**
     * 标准结果转换器（实现SQL执行结果列有序）
     */
    private static final ThreadLocal<Boolean> standardTransformerThreadLocal = new ThreadLocal<>();
    /**
     * 禁用日志输出
     */
    private static final ThreadLocal<Boolean> disableLogPrintThreadLocal = new ThreadLocal<>();

    public static boolean getStandardTransformerValue() {
        Boolean yn = standardTransformerThreadLocal.get();
        return Objects.requireNonNullElse(yn, false);
    }

    public static boolean getDisableLogPrintValue() {
        Boolean yn = disableLogPrintThreadLocal.get();
        return Objects.requireNonNullElse(yn, false);
    }

    public static void openStandardTransformer() {
        standardTransformerThreadLocal.set(true);
    }

    public static void closeStandardTransformer() {
        standardTransformerThreadLocal.remove();
    }

    public static void disableLogPrint() {
        disableLogPrintThreadLocal.set(true);
    }

    public static void enableLogPrint() {
        disableLogPrintThreadLocal.remove();
    }
}
