/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.transformer;

import cn.hutool.core.date.DateUtil;
import com.af.v4.system.common.jpa.utils.ClobUtil;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

public class StandardAliasTransformer
extends AliasedTupleSubsetResultTransformer {
    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    private StandardAliasTransformer() {
    }

    protected static void runTrans(Object obj, Object[] tuple, String[] aliases) {
        for (int i = 0; i < aliases.length; ++i) {
            Object value;
            String alias = aliases[i];
            Object object = value = tuple[i];
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, Date.class, Clob.class}, (Object)object, n)) {
                case -1: {
                    value = JSONObject.NULL;
                    break;
                }
                case 0: {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    if (!StandardAliasTransformer.isIntegerValue(bigDecimal)) break;
                    long longValue = bigDecimal.longValue();
                    if (longValue < Integer.MAX_VALUE) {
                        value = (int)longValue;
                        break;
                    }
                    value = longValue;
                    break;
                }
                case 1: {
                    Date date = (Date)object;
                    value = DateUtil.formatDateTime((Date)date);
                    break;
                }
                case 2: {
                    Clob clob = (Clob)object;
                    value = ClobUtil.getClobString(clob);
                    break;
                }
            }
            if (obj instanceof JSONObject) {
                JSONObject object2 = (JSONObject)obj;
                object2.put(alias.toLowerCase(), value);
                continue;
            }
            if (!(obj instanceof Map)) continue;
            Map objectMap = (Map)obj;
            objectMap.put(alias.toLowerCase(), value);
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    public Map<String, Object> transformTuple(Object[] tuple, String[] aliases) {
        LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>(aliases.length);
        StandardAliasTransformer.runTrans(objectMap, tuple, aliases);
        return objectMap;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }
}

