package com.af.v4.system.common.jpa.dialect;

import com.af.v4.system.common.datasource.DynamicDataSource;
import org.hibernate.dialect.*;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;

import java.lang.reflect.InvocationTargetException;

/**
 * 自定义方言解析器
 */
public final class MyDialectResolver implements DialectResolver {

    @Override
    public Dialect resolveDialect(DialectResolutionInfo info) {
        for (Database database : Database.values()) {
            Dialect dialect = database.resolveDialect(info);
            if (dialect != null) {
                if (dialect instanceof SQLServerDialect) {
                    if (dialect instanceof SQLServer2016Dialect) {
                        return new MySqlServerDialect2();
                    } else {
                        return new MySqlServerDialect();
                    }
                } else if (dialect instanceof org.hibernate.dialect.MySQLDialect) {
                    if (dialect instanceof MySQL8Dialect) {
                        return new MySQLDialect2();
                    } else {
                        return new MySQLDialect();
                    }
                } else if (dialect instanceof Oracle8iDialect) {
                    return new MyOracle10gDialect();
                }
                return dialect;
            }
        }
        if (info.getDatabaseName().contains("ClickHouse")) {
            return new MyClickHouseDialect();
        }
        try {
            return (Dialect) Class.forName(DynamicDataSource.getDruidDataSource().getDialect()).getConstructors()[0].newInstance();
        } catch (ClassNotFoundException | InvocationTargetException | InstantiationException |
                 IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}
