/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.report.service;

import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.report.core.Report;
import com.af.v4.system.common.resource.mapper.ReportMapper;
import org.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ReportService {
    private final ApplicationUtils applicationUtils;
    private final ReportMapper reportMapper;
    private final SqlService sqlService;

    public ReportService(ApplicationUtils applicationUtils, ReportMapper reportMapper, SqlService sqlService) {
        this.applicationUtils = applicationUtils;
        this.reportMapper = reportMapper;
        this.sqlService = sqlService;
    }

    public Object run(String reportName, JSONObject params) {
        ReportMapper.ReportResource resource = (ReportMapper.ReportResource)this.reportMapper.getResource(reportName);
        String source = resource.getSource();
        params.put("ENV", (Object)this.applicationUtils.getValues());
        params.put("RESOURCE", (Object)resource.getJsonParams());
        Report report = new Report(source, params, this.sqlService);
        return report.render();
    }
}

