package com.af.v4.system.common.report.service;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.expression.report.core.Report;
import com.af.v4.system.common.expression.report.core.Sql;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.resource.mapper.ReportMapper;
import org.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor = Exception.class)
public class ReportService {
    private final ApplicationUtils applicationUtils;

    private final ReportMapper reportMapper;

    private final SqlService sqlService;

    public ReportService(ApplicationUtils applicationUtils, ReportMapper reportMapper, SqlService sqlService) {
        this.applicationUtils = applicationUtils;
        this.reportMapper = reportMapper;
        this.sqlService = sqlService;
    }

    /**
     * 执行报表
     *
     * @param reportName 报表名称
     * @param params     报表参数
     * @return 执行结果
     */
    public Object run(String reportName, JSONObject params) {
        // 获取源程序内容
        ReportMapper.ReportResource resource = reportMapper.getResource(reportName);
        String source = resource.getSource();
        // 附加用户注册的对象到报表中
        params.put("ENV", applicationUtils.getValues());
        params.put("RESOURCE", resource.getJsonParams());
        Report report = new Report(source, params);
        return runExpression(report);
    }

    /**
     * 执行原生表达式
     *
     * @param report REPORT对象
     * @return 执行结果
     */
    public Object runExpression(Report report) {
        // 执行sql语句，把结果保存起来，方便单元格调用
        for (Sql item : report.sqls) {
            // sql的param按表达式执行
            Program proc = new Program(item.param);
            Delegate delegate = proc.parse();
            JSONObject json = (JSONObject) delegate.invoke(report.vars);
            // 调用sql处理，把结果保存到sqlResult中
            Object ret = sqlService.query(item.sql, json);
            report.vars.put(item.name, ret);
        }
        return report.render();
    }
}
