/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.jpa.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.expression.Expression;
import com.af.v4.system.common.jpa.action.SqlAction;
import com.af.v4.system.common.jpa.utils.SQLRuntimeSupport;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.enums.ResourceType;
import com.af.v4.system.common.resource.mapper.SqlMapper;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlService.class);
    private final SqlMapper sqlMapper;
    private final SqlAction sqlAction;

    public SqlService(SqlMapper sqlMapper, SqlAction sqlAction) {
        this.sqlMapper = sqlMapper;
        this.sqlAction = sqlAction;
    }

    public String getSQL(String name, JSONObject params) {
        return this.getSQLByFile(name, params);
    }

    public JSONObject queryTotal(String name, JSONObject params) {
        Object sums = null;
        JSONObject param = params.has("data") ? params.getJSONObject("data") : new JSONObject();
        if (params.has("sums")) {
            sums = params.get("sums");
        }
        String sql = this.getSQLByFile(name, param);
        sql = this.filterOutOrderBy(sql, sums);
        JSONArray array = this.sqlAction.query(name, sql);
        return array.getJSONObject(0);
    }

    public JSONObject queryTotal(String name, String str) {
        return this.queryTotal(name, StringUtils.isEmpty((String)str) ? new JSONObject() : new JSONObject(str));
    }

    public JSONArray query(String name, JSONObject params, Integer pageNo, Integer pageSize) {
        String sql = this.getSQLByFile(name, params);
        return pageSize <= 0 ? this.sqlAction.queryAll(name, sql) : this.sqlAction.query(name, sql, pageNo - 1, pageSize);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) {
        return this.query(name, params, 1, pageSize);
    }

    public JSONArray query(String name, JSONObject params) {
        return this.query(name, params, 1, 1000);
    }

    public JSONArray querySQL(String name, String sql) {
        return this.querySQL(name, sql, 1, 1000);
    }

    public JSONArray querySQL(String name, String sql, Integer pageSize) {
        return this.querySQL(name, sql, 1, pageSize);
    }

    public JSONArray querySQL(String name, String sql, Integer pageNo, Integer pageSize) {
        return pageSize <= 0 ? this.sqlAction.queryAll(name, sql) : this.sqlAction.query(name, sql, pageNo - 1, pageSize);
    }

    public Integer exec(String name, JSONObject params) {
        String sql = this.getSQLByFile(name, params);
        return this.execSQL(name, sql);
    }

    public Integer execSQL(String name, String sql) {
        return this.sqlAction.exec(name, sql);
    }

    private String getSQLByFile(String sqlName, JSONObject json) {
        SqlMapper.SqlResource resource = this.sqlMapper.getValue(sqlName);
        if (Optional.ofNullable(resource).isEmpty()) {
            throw new ServiceException("sql[" + sqlName + "]\u672a\u6ce8\u518c\uff01", Integer.valueOf(400));
        }
        String path = resource.getPath().toString();
        String sql = ResourceIndexer.getString((ResourceType)ResourceType.SQL, (String)resource.getAlias(), (String)path);
        json.put("sql", (Object)this);
        sql = Expression.run((String)sql, (Map)json.toMap()).toString();
        return sql;
    }

    private String filterOutOrderBy(String source, Object sums) {
        int idx = source.toLowerCase().lastIndexOf("order by");
        if (idx == -1) {
            idx = source.length() - 1;
        }
        StringBuilder sql = new StringBuilder("select ");
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql.append("sum(").append(name).append(") ").append(name).append(", ");
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql.append("sum(").append(value).append(") ").append(name).append(", ");
                }
            }
        }
        if (idx != -1) {
            sql.append("count(*) n, 1 placeholder from ( ").append(source, 0, idx).append(") t_");
        }
        return sql.toString();
    }

    public String getDbTypeName() {
        return DynamicDataSource.getDbType().name();
    }

    public String resolveSQL(JSONObject sqlList) {
        String dbType = this.getDbTypeName();
        String sqlStr = sqlList.optString(dbType, null);
        if (sqlStr == null) {
            throw new ServiceException("\u672a\u627e\u5230\u7b26\u5408\u6570\u636e\u6e90[" + dbType + "]\u7684SQL");
        }
        return sqlStr;
    }

    public void openStandardTransformerSupport() {
        SQLRuntimeSupport.openStandardTransformer();
    }

    public void closeStandardTransformerSupport() {
        SQLRuntimeSupport.closeStandardTransformer();
    }

    public void disableLogPrint() {
        SQLRuntimeSupport.disableLogPrint();
    }

    public void enableLogPrint() {
        SQLRuntimeSupport.enableLogPrint();
    }
}

