package com.af.v4.system.common.jpa.transformer;

import cn.hutool.core.date.DateUtil;
import com.af.v4.system.common.jpa.utils.ClobUtil;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.io.Serial;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 标准结果转换器
 */
public class StandardAliasTransformer extends AliasedTupleSubsetResultTransformer {

    public static final StandardAliasTransformer INSTANCE = new StandardAliasTransformer();

    /**
     * Disallow instantiation of AliasToEntityMapResultTransformer.
     */
    private StandardAliasTransformer() {
    }

    protected static void runTrans(Object obj, Object[] tuple, String[] aliases) {
        for (int i = 0; i < aliases.length; i++) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias != null) {
                if (value instanceof BigDecimal bigDecimal) {
                    if (isIntegerValue(bigDecimal)) {
                        long longValue = bigDecimal.longValue();
                        if (longValue < Integer.MAX_VALUE) {
                            value = (int) longValue;
                        } else {
                            value = longValue;
                        }
                    }
                } else if (value instanceof Date date) {
                    // 处理日期格式
                    value = DateUtil.formatDateTime(date);
                } else if (value instanceof Clob clob) {
                    value = ClobUtil.getClobString(clob);
                }
                if (obj instanceof JSONObject object) {
                    object.put(alias.toLowerCase(), value);
                } else if (obj instanceof Map objectMap) {
                    objectMap.put(alias.toLowerCase(), value);
                }
            }
        }
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    @Override
    public Map<String, Object> transformTuple(Object[] tuple, String[] aliases) {
        Map<String, Object> objectMap = new LinkedHashMap<>(aliases.length);
        runTrans(objectMap, tuple, aliases);
        return objectMap;
    }

    @Override
    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    @Serial
    private Object readResolve() {
        return INSTANCE;
    }
}
